/* $Id: ArkStream.cpp,v 1.15 2002/10/11 01:10:05 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <Ark/ArkStream.h>
#include <Ark/ArkSystem.h>
#include <Ark/ArkFileSys.h>

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#include <sstream>

#include <stdio.h>
#include <stdlib.h>


namespace Ark
{


AutoReadStream::AutoReadStream(const String& filename, std::ios::openmode mode)
{
    String real = Sys()->FS()->GetFileName (filename);
    m_Stream = new std::ifstream( real.c_str(), mode );
}


AutoReadStream::~AutoReadStream()
{ 
    if (m_Stream) 
    { 
	m_Stream->close(); 
	delete m_Stream; 
    } 
}

/* namespace Ark */
}
