/* Copyright (C) 2002, 2003, 2004, 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __XMLREFERENCE_HPP
#define __XMLREFERENCE_HPP

#include <cassert>
#include <string>
#include <util/XMLException.hpp>
#include "error.hpp"
#include "object.hpp"

#ifdef XERCES_HAS_CPP_NAMESPACE
using namespace XERCES_CPP_NAMESPACE;
#endif
#ifdef XALAN_HAS_CPP_NAMESPACE
using namespace XALAN_CPP_NAMESPACE;
#endif

class XMLDocument;
class XMLNodeReferenceList;

/** @addtogroup XMLCpp
    @{ */
/** Wrapper for XML-nodes and -elements of the Apache-library.
    @date Mon Jan 10 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
template< class T >
class XMLReference: public Object
{
 public:
  ///
  XMLReference( T *_node, XMLDocument *_document );
  ///
  XMLReference( const XMLReference< T > &r );
  ///
  XMLReference< T > &operator=( const XMLReference< T > &r );
  ///
  T &operator*(void) const { assert( node != NULL ); return *node; }
  ///
  T *operator->(void) const { assert( node != NULL ); return node; }
  ///
  T *get(void) const { return node; }
  ///
  operator bool(void) const { return node != NULL; }
  ///
  bool operator! () const { return node == NULL; }
  ///
  std::string getNodeText(void) throw (Error,XMLException);
  /// Only implemented for XalanElement.
  XMLReference< XalanNode > selectNode( const std::string &xPath )
    throw (Error,XMLException);
  /// Only implemented for XalanElement.
  XMLNodeReferenceList selectNodes( const std::string &xPath )
    throw (Error,XMLException);
  /// Only implemented for XalanElement.
  bool existNode( const std::string &xPath ) throw (XMLException);
  ///
  XMLDocument *getDocument(void) const { return document; }
 protected:
  ///
  T *node;
  ///
  XMLDocument *document;
};

///
template<class T, class U>
XMLReference<T> dynamic_pointer_cast( XMLReference<U> const & r )
{
  return XMLReference<T>( (T *)r.get(), r.getDocument() );
}

///@}

#include "xmlReference.tcc"

#endif
