/* Copyright (C) 2002, 2003, 2004, 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __XMLNODEREFERENCELIST_HPP
#define __XMLNODEREFERENCELIST_HPP

#include "include.hpp"
#include <boost/shared_ptr.hpp>
#include <XPath/NodeRefList.hpp>
#include <XPath/XObject.hpp>
#include "xmlReference.hpp"
#include "object.hpp"

/** @addtogroup XMLCpp
    @{ */
/** List of XML-nodes.
    @date Sat Feb 05 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class XMLNodeReferenceList: public Object
{
public:
#ifdef SIMPLEXPATH
  XMLNodeReferenceList( const NodeRefList &_nodeList,
                        XMLDocument *_document ):
    nodeList(_nodeList), document(_document) {}
#else
  XMLNodeReferenceList( boost::shared_ptr< XObjectPtr > _xObject,
                        XMLDocument *_document ):
    xObject( _xObject ), nodeList( (*_xObject)->nodeset() ),
    document(_document) {}
#endif
  XMLNodeReferenceList( const XMLNodeReferenceList &l );
  XMLReference< XalanNode > item( int index ) const;
  int getLength(void) const;
protected:
#ifdef SIMPLEXPATH
  NodeRefList nodeList;
#else
  boost::shared_ptr< XObjectPtr > xObject;
  const NodeRefListBase &nodeList;
#endif
  XMLDocument *document;
};

///@}

#endif
