// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "parameter.h"

Parameter::Parameter() :
		str_unknown( "Unknown" ),
		str_none( "None" )
{
}

Parameter::~Parameter()
{
}

void Parameter::addParam( const std::string &prefix, const std::string &info, const std::string &help,
                          const param_e typ, const std::string &value )
{
	param_t np;
	np.Info = info;
	np.Help = help;
	np.Typ = typ;
	np.Value = value;
	mapParam[ prefix ] = np;
}
long Parameter::getIntParam( const std::string &prefix )
{
	return atol( mapParam[ prefix ].Value.c_str() );
}
std::string Parameter::getStringParam( const std::string &prefix )
{
	return mapParam[ prefix ].Value;
}
bool Parameter::getFlagParam( const std::string &prefix )
{
	std::string flag = mapParam[ prefix ].Value;
	if ( flag == "1" || flag == "y" || flag == "yes" || flag == "true" || flag == "on" ) return true;
	if ( flag == "0" || flag == "n" || flag == "no" || flag == "false" || flag == "off" ) return false;
	if ( flag == "Y" || flag == "Yes" || flag == "True" || flag == "On" ) return true;
	if ( flag == "N" || flag == "No" || flag == "False" || flag == "Off" ) return false;
	return false; // Zweifelsfall.
};

