// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef LTANALYSE_H
#define LTANALYSE_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "analyse.h"

/** The local traffic analysis plugin create a statistic about all received
  * traffic from internal and external people. The result is sorted by
  * the totalsize of traffic (mailsize * receipients).
  *@short Local traffic analysis plugin.
  *@author Tobias Erbsland
  */
class ltAnalyse : public Analyse
{
private:
	const char * const strPrefix;
	const char * const strName;
	const char * const strVersion;
	const char * const strAuthor;
	const char * const strHelp;

	/** Map for the analysis. */
	std::multimap< long, std::string > intern_traffic;
	/** Map for the analysis. */
	std::map< std::string, long > ext_to_intern_traffic_c;
	/** Map for the analysis. */
	std::map< std::string, long > mailc_toi_c;
	/** Map for the analysis. */
	std::map< std::string, long > mailc_toi_frome_c;

public:
	ltAnalyse();

	virtual const char * Prefix( void ) const { return strPrefix; };
	virtual const char * Name( void ) const { return strName; };
	virtual const char * Version( void ) const { return strVersion; };
	virtual const char * Author( void ) const { return strAuthor; };
	virtual const char * Help( void ) const { return strHelp; };

	virtual	void run( std::map< std::string, unity_t > * unity_map );
	virtual void print( void );
	virtual void free( void );

	virtual ~ltAnalyse() { };
};

#endif
