// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================


#ifndef FILTER_H
#define FILTER_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <ctime>
#include "parameter.h"
#include "analyse.h"

class Plugin;

/** The abstract filter basis class.
  *@author Tobias Erbsland
  */
class Filter : public Parameter
{

protected:
	static std::map<std::string, Analyse::unity_t> unity_map;
	std::istream * is; // default inputstream.

	std::string strLowerCase( const std::string &strHi );
	int strToMonth( const std::string &month );

	Plugin * afp; // Adress Filter Plugin.

public:
	Filter() : is( 0 ) { };

	virtual bool run( void ) = 0;

	virtual void free( void ) { unity_map.clear(); };
	static std::map<std::string, Analyse::unity_t> * unityMap( void ) { return &unity_map; };

	virtual void setIstream( std::istream * newis ) { is = newis; };
	virtual std::istream * getIstream( void ) { return is; };

	virtual void setCheckAddr( Plugin * func ) { afp = func; };

	virtual ~Filter();

};

#endif
