<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     version="1.1">

<!-- ####################################### -->
<!-- ####################################### -->
<!-- Write slideshow html pages -->
<xsl:template match="album" mode="slideshows">
<xsl:for-each select="subalbum">
  <xsl:variable name="subalbumNumber" select="position()"/>
  <xsl:variable name="photoCount" select="count(photo)"/>
  <xsl:document method="html" indent="yes" href="{concat($outputPath, '/subalbum_', string(position()), '_slideshow.html')}">
    <html>
      <head>
        <meta name="generator" content="Album Shaper (c.) Will Stokes"/>
        <style type="text/html">
          &lt;!--
          A{text-decoration:none}
          --&gt;
        </style>
        <style type="text/css">
          &lt;!--
          h3 {font-size: 12pt; font-weight: bold; text-align: center}
          h4 {font-size: 10pt; font-weight: normal; text-align: center}
          h4.ital {font-size: 10pt; font-weight: normal; text-align: center}
          --&gt;
        </style>
        <title><xsl:value-of select="name"/></title>
        <script type="text/javascript" language="JavaScript">
        <![CDATA[
        <!-- HIDE FROM OLD BROWSERS
        var imageNumber=1

        var photoTitles = new Array(]]><xsl:value-of select="count(photo)"/><![CDATA[);

        ]]>
        <xsl:for-each select="photo">
          <xsl:variable name="photoDescription" select="description"/>
          photoTitles[<xsl:value-of select="position()-1"/>] = <![CDATA["]]><xsl:call-template name="JavaScriptString">
                                      <xsl:with-param name="string" select="$photoDescription"/>
                                     </xsl:call-template><![CDATA["]]>;
        </xsl:for-each>
        <![CDATA[

        //######################################
        //Define functions used to change images
        //######################################
        function expandImage()
        {
          fileToOpen = "img/]]><xsl:value-of select="$subalbumNumber"/><![CDATA[/"+imageNumber+".jpg"
          new_window = window.open(fileToOpen,'albulmifyRules')
        }

        function reloadImage()
        {
          document.currentPhoto.src="img/]]><xsl:value-of select="$subalbumNumber"/><![CDATA[/"+imageNumber+"_slideshow.jpg"
          document.currentPhoto.alt=photoTitles[imageNumber-1];
          document.photoInfo.whichPhoto.value="Photo " + imageNumber + " of ]]><xsl:value-of select="count(photo)"/><![CDATA["
          document.photoInfo.photoDesc.value=photoTitles[imageNumber-1];
        }

        function firstImage()
        {
          //set image number to first
          imageNumber = 1

          //reset image src value based on variable
          reloadImage()
        }

        function lastImage()
        {
          //set image number to last
          imageNumber = ]]><xsl:value-of select="count(photo)"/><![CDATA[

          //reset image src value based on variable
          reloadImage()
        }

        function nextImage()
        {
          //increment image number
          imageNumber = imageNumber + 1

          //wrap to begining if reached the end
          if (imageNumber==]]><xsl:value-of select="1 + count(photo)"/><![CDATA[)
          {imageNumber = 1}

          //reset image src value based on variable
          reloadImage()
        }

        function previousImage()
        {
          //decrement image number
          imageNumber = imageNumber - 1
          //wrap to begining if reached the end
          if (imageNumber==(1 - 1))
          {imageNumber = ]]><xsl:value-of select="count(photo)"/><![CDATA[}

          //reset image src value based on variable
          reloadImage()
        }
        -->
        ]]>
        </script>
      </head>
      <body>
        <center>
          <table border="0">
            <tr>
              <td width="450">
                <h3>
                  <xsl:value-of select="name"/>
                </h3>
                <h4>
                  <xsl:value-of select="description"/>
                </h4>
              </td>
            </tr>
          </table>
        </center>
        <h4>
          <a href="subalbum_{position()}_thumbs.html">
            Thumbnails
          </a>
          <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;-&nbsp;]]></xsl:text>
          <a href="Album.html">
            Album Index
          </a>
        </h4>

        <center>

        <!-- Disable expanding to large image in small web exports because they are not included! -->
        <xsl:if test="$smallWebExport=1">
          <img alt="current photo" src="img/{$subalbumNumber}/1_slideshow.jpg" name="currentPhoto" border="0"/>
        </xsl:if>

        <xsl:if test="$smallWebExport=0">
          <a href="JavaScript:expandImage()">
            <img alt="current photo" src="img/{$subalbumNumber}/1_slideshow.jpg" name="currentPhoto" border="0"/>
          </a>
        </xsl:if>

        </center>
        <center>
          <form name="photoInfo" action="">
            <table border="0">
              <tr>
                <td valign="middle" align="center" width="100">
                  <a href="JavaScript:firstImage()"> (First) </a>
                </td>
                <td valign="middle" align="center" width="100">
                  <a href="JavaScript:previousImage()"> Previous </a>
                </td>
                <td valign="middle" align="center">
                  <input type="text" maxlength="100" name="whichPhoto" readonly="true" value="Photo 1 of {$photoCount}"/>
                </td>
                <td valign="middle" align="center" width="100">
                  <a href="JavaScript:nextImage()"> Next </a>
                </td>
                <td valign="middle" align="center" width="100">
                  <a href="JavaScript:lastImage()"> (Last) </a>
                </td>
              </tr>
              <tr>
                <td colspan="5" valign="middle" align="center">
                  <textarea cols="40" rows="2" name="photoDesc" readonly="true">
                    <xsl:value-of select="photo/description"/>
                  </textarea>
                </td>
              </tr>
            </table>
          </form>
        </center>
        <h4 class="ital">
          (Generated by <a href="http://albumshaper.sourceforge.net">Album Shaper</a>, Classic theme)
        </h4>
      </body>
    </html>
  </xsl:document>
</xsl:for-each>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->

</xsl:stylesheet>
