package VC8WorkspaceCreator;

# ************************************************************
# Description   : A VC8 Workspace Creator
# Author        : Johnny Willemsen
# Create Date   : 4/21/2004
# ************************************************************

# ************************************************************
# Pragmas
# ************************************************************

use strict;

use VC8ProjectCreator;
use VC71WorkspaceCreator;

use vars qw(@ISA);
@ISA = qw(VC71WorkspaceCreator);

# ************************************************************
# Subroutine Section
# ************************************************************


sub pre_workspace {
  my($self) = shift;
  my($fh)   = shift;
  my($crlf) = $self->crlf();

  print $fh $crlf,
            'Microsoft Visual Studio Solution File, Format Version 9.00', $crlf,
            '# Visual Studio 2005', $crlf,
            '# VC8WorkspaceCreator.pm,v 1.3 2005/05/16 16:41:30 elliott_c Exp', $crlf,
            '#', $crlf,
            '# This file was generated by MPC.  Any changes made directly to', $crlf,
            '# this file will be lost the next time it is generated.', $crlf,
            '#', $crlf,
            '# MPC Command:', $crlf,
            "# $0 @ARGV", $crlf;
}

sub get_short_config_name {
  my($self) = shift;
  my($cfg)  = shift;
  return $cfg;
}

sub get_solution_config_section_name {
  #my($self) = shift;
  return 'SolutionConfigurationPlatforms';
}

sub get_project_config_section_name {
  #my($self) = shift;
  return 'ProjectConfigurationPlatforms';
}

sub print_additional_sections {
  my($self) = shift;
  my($fh)   = shift;
  my($crlf) = $self->crlf();

  print $fh "\tGlobalSection(SolutionProperties) = preSolution$crlf",
            "\t\tHideSolutionNode = FALSE$crlf",
            "\tEndGlobalSection$crlf";
}

sub allow_empty_dependencies {
  #my($self) = shift;
  return 0;
}



1;
