/*
 * This file is part of qVamps.
 *
 * qVamps is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * qVamps is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with qVamps; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


%module LibDvdRead
%{
#include <stdio.h>
#include <inttypes.h>
#include <dvdread/ifo_read.h>
%}


%inline %{
#ifndef SWIG
static char		volid [32];
static unsigned char	volsetid [128];
#endif


const char *
DVDVolumeIdentifier (dvd_reader_t *dvd)
{
  if (DVDUDFVolumeInfo (dvd, volid, sizeof (volid),
			volsetid, sizeof (volsetid)) < 0)
    return NULL;

  return volid;
}


const char *
DVDVolumeSetIdentifier (dvd_reader_t *dvd)
{
  if (DVDUDFVolumeInfo (dvd, volid, sizeof (volid),
			volsetid, sizeof (volsetid)) < 0)
    return NULL;

  return (char *) volsetid;
}


const char *
DVDDiscIdentifier (dvd_reader_t *dvd)
{
  static unsigned char discid [16];

  if (DVDDiscID (dvd, discid) < 0)
    return NULL;

  return (char *) discid;
}
%}


#define __extension__
#define __attribute__(x)
#define __const			const
#define __restrict
#define __inline

%include "ignores.i"
%include "ifo_read.i"


%include "carrays.i"
%array_functions(title_info_t, title_info_array);
%array_functions(ttu_t, ttu_array);
%array_functions(audio_attr_t, audio_attr_array);
%array_functions(subp_attr_t, subp_attr_array);
%array_functions(ptt_info_t, ptt_info_array);
%array_functions(pgci_srp_t, pgci_srp_array);
%array_functions(pgc_program_map_t, pgc_program_map_array);
%array_functions(cell_playback_t, cell_playback_array);
%array_functions(uint32_t, palette);


%constant int BLOCK_TYPE_NONE         = 0x0;
%constant int BLOCK_TYPE_ANGLE_BLOCK  = 0x1;
