/****************************************************************************
** ListViewItemMedia class to display the Video sources name, and thumbnail
**
**   Created : Thu Nov 25 12:09:08 2004
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class re-implements the QListViewItem class and adds 
** 1) a thumbnail preview of the video(s)
** 2) a tree-node with a list of all included SourceFileInfo's
****************************************************************************/

#ifndef LISTVIEWITEMMEDIA_H
#define LISTVIEWITEMMEDIA_H

#include <qlistview.h>

class SourceFileEntry;
class SourceFileInfo;

class ListViewItemMedia : public QListViewItem
{
	enum enButtonState {StateUndef = 0, StateStop, StatePlay, StateBack};
public:
	ListViewItemMedia ( QListView     *, SourceFileEntry *, const QColor & );
	ListViewItemMedia ( QListViewItem *, SourceFileEntry *, const QColor & );
	ListViewItemMedia ( QListView     *, QListViewItem   *, SourceFileEntry *, const QColor & );
	ListViewItemMedia ( QListViewItem *, SourceFileInfo  *, const QColor &, QString, QString, QString );
	virtual ~ListViewItemMedia       ( );

	SourceFileEntry *sourceFileEntry ( );
	SourceFileInfo  *sourceFileInfo  ( );
	// Overloaded function
	virtual void paintCell ( QPainter *, const QColorGroup &, int, int, int );
	QColor backgroundColor ( );
	void   replaceInfo     ( SourceFileInfo * );
	void   updateItem      ( );

	void itemClicked       ( QPoint & );

private:
	void initMe ( SourceFileEntry *, const QColor & );
	QPixmap &attachButtons ( QImage &, QSize );
	void drawButtonState   ( QPixmap * );

private:
	uint m_iButtonState;
	uint m_iPreviousButtonState;

	QColor m_backgroundColor;
	// Only one of the two possible data is valid
	SourceFileEntry *m_pSourceFileEntry;
	SourceFileInfo  *m_pSourceFileInfo;
};

#endif // LISTVIEWITEMMEDIA_H
