/****************************************************************************
** Class Keyword 
**
**   Created : Fri 08 Dec 12:09:08 2005
**        by : Varol Okan using XEmacs
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class will replace a given token in a string with a value
**
****************************************************************************/

#ifndef KEYWORD_H
#define KEYWORD_H

#include <qstringlist.h>

class Keyword
{
public:
  enum enKeyBase { Keys, TransKeys, SubKeys, BaseLast };

  enum enTranscodeKeys {
    TransDVDAuthorXML=0,   TransProjectPath, TransTempPath,    TransInputName , 
    TransBaseName,         TransFileExt,     TransAudioFormat, TransAudioType, 
    TransAudioBitrate,     TransSampleRate,  TransStartingAt,  TransEndingAt,
    TransWidth,            TransHeight,      TransVideoFormat, TransVideoType, 
    TransVideoBitrate,     TransFrameRate,   TransRatio,       TransAudioList, 
    TransForEachCounter,   TransTrackName,   TransLast
  };
  enum enKeys {
    KeyDVDAuthorXML=0,     KeyProjectPath,   KeyTempPath,      KeyWidth, 
    KeyHeight,             KeyFormat,        KeyMenuName,      KeyAspectRatio,
    KeyStartPos,           KeyDuration,      KeyNrOfFrames,    KeyBackgroundFileName, 
    KeyBackgroundFullName, KeySoundList,     KeyLast
  };
  enum enSubtitlesKeys {
    SubProjectPath=0,  SubTempPath, SubInputFileName, SubXmlFile, SubBaseName,
    SubFileExt, SubSubtitleNumber, SubMultipleSubtitlePipe, SubLast
  };
  
  class Entry {
  public:
     Entry  ( ) { iIndex = 0; };
    ~Entry  ( ) { };
    QString qsKey;
    QString qsValue;
    int     iIndex;
  };

   Keyword ();
  ~Keyword ();

  void        printf                           ( int );
  int         count                            ( int );
  void        clear                            ( int );
  QString     value                       ( int, int );
  QString     key                         ( int, int );
  bool        setValue           ( int, int, QString );
  QString     resolvString            ( int, QString );
  QString     resolvConvert       ( QString, QString );
  QStringList getValues                        ( int );
  QStringList getKeys                          ( int );
  void        setKeywords ( int, QValueList<QString> );

private:
  QValueList<Entry *> m_listOfPair    [ BaseLast ];
};

#endif // KEYWORD_H


