/*
**	penguin_utils.c 12/01/98 Mikael Forselius <mikaelf@comenius.se>
**
**	This file is subject to the terms and conditions of the GNU General Public
**	License.  See the file COPYING in the main directory of this archive
**	for more details.
**
**	Misc useful routines
**
*/
#include <Aliases.h>
#include <LowMem.h>
#include <StandardFile.h>
#include <Traps.h>

#include "penguin_prototypes.h"
#include "penguin_utils.h"

/*
 *	GestaltBitSet
 *
 *	Convienient routine for checking a _Gestalt
 *	response bit setting.
 */
short GestaltBitSet(long gestaltResponse, long whichBit)
{
	return (gestaltResponse & (1L << whichBit));
}


/*
 *	path_from_FSSpec
 *
 *	Return path to the file having FSSpec pFSS
 */
OSErr
path_from_FSSpec(ConstFSSpecPtr pFSS, Str255 strPath)
{
	CInfoPBRec		cpb;
	Str255			strCat, strFile;
	StringPtr		pStrCat, pStrPath;
	long			dirID;
	OSErr			err;

	pStrCat = strCat;
	pStrPath = strPath;

	BlockMoveData(pFSS->name, pStrPath, pFSS->name[0]+1);
	dirID = pFSS->parID;
	err = noErr;

	BlockMoveData(pFSS->name, strFile, pFSS->name[0]+1);
	strFile[strFile[0]+1] = 0;

	while( (err == noErr) && (dirID != 1) ) {
		*pStrCat = 0;
		cpb.dirInfo.ioCompletion = nil;
		cpb.dirInfo.ioNamePtr = pStrCat;
		cpb.dirInfo.ioVRefNum = pFSS->vRefNum;
		cpb.dirInfo.ioFRefNum = 0;
		cpb.dirInfo.ioFDirIndex = 0x8000;
		cpb.dirInfo.ioDrDirID = dirID;
		err = PBGetCatInfoSync(&cpb);
		if (err == noErr) {
			if ( (*pStrPath + *pStrCat) >= 253) {
				cprintf("*** Error: Path to '%s' > 255 char's\n", &strFile[1]);
				err = -1;
			}
			else {
				pStrCat[++*pStrCat] = ':';
				BlockMoveData(&pStrPath[1], &pStrCat[*pStrCat+1], *pStrPath);
				*pStrCat += *pStrPath;
				BlockMoveData(pStrCat, pStrPath, *pStrCat+1);
				dirID = cpb.dirInfo.ioDrParID;
			}
		}
	}

	return err;
}

/*
 *	have_trap
 *
 */
unsigned long have_trap (unsigned long trap)
{
	Boolean			trapPresent;
	short			trapType;
	unsigned long	unimpAddr;
	unsigned long	trapAddr;
	
	trapType = (trap & 0x0800) ? ToolTrap : OSTrap;
	unimpAddr = (unsigned long) GetToolboxTrapAddress(_Unimplemented); 
	trapAddr = (unsigned long) NGetTrapAddress(trap, trapType);

	trapPresent = false;
	if (trapAddr != unimpAddr)
		trapPresent = true;

	return trapPresent;
}

/*
 *	sfgetfile_dir
 *
 *	Presents StandardGetFile dialog at given vol/dir
 *
 */
void
sfgetfile_dir(short vRefNum, long dirID,
	short numTypes, SFTypeList *typeList, StandardFileReply *reply)
{
	long		saveDir;
	short		saveVol;
	
	saveDir = LMGetCurDirStore();
	saveVol = LMGetSFSaveDisk()	;

	LMSetCurDirStore(dirID);
	LMSetSFSaveDisk(-vRefNum);

	StandardGetFile(NULL, numTypes, (const unsigned long *)typeList, reply);

	LMSetCurDirStore(saveDir);
	LMSetSFSaveDisk(saveVol);
}

/*
 *	sfputfile_dir
 *
 *	Presents StandardPutFile dialog at given vol/dir
 *
 */
void
sfputfile_dir(short vRefNum, long dirID,
	unsigned char *prompt, unsigned char *defaultName, StandardFileReply *reply)
{
	long		saveDir;
	short		saveVol;
	
	saveDir = LMGetCurDirStore();
	saveVol = LMGetSFSaveDisk();

	LMSetCurDirStore(dirID);
	LMSetSFSaveDisk(-vRefNum);

	StandardPutFile(prompt, defaultName, reply);

	LMSetCurDirStore(saveDir);
	LMSetSFSaveDisk(saveVol);
}

/*
 *	get_hvol
 *
 */
OSErr
get_hvol(HParmBlkPtr hpbp)
{
	hpbp->wdParam.ioCompletion = nil;
	return PBHGetVolSync((WDPBPtr)hpbp);
}

/*
 *	set_hvol
 *
 */
OSErr
set_hvol(short vRefNum, long dirID)
{
	HParamBlockRec	hpb;

	hpb.wdParam.ioCompletion = nil;
	hpb.wdParam.ioNamePtr = nil;
	hpb.wdParam.ioVRefNum = vRefNum;
	hpb.wdParam.ioWDDirID = dirID;

	return PBHSetVolSync((WDPBPtr)&hpb);
}
