/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_WAV_H__
#define __OGMRIP_WAV_H__

#include <ogmrip-audio.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_WAV          (ogmrip_wav_get_type ())
#define OGMRIP_WAV(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_WAV, OGMRipWav))
#define OGMRIP_WAV_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_WAV, OGMRipWavClass))
#define OGMRIP_IS_WAV(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_WAV))
#define OGMRIP_IS_WAV_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_WAV))

typedef struct _OGMRipWav      OGMRipWav;
typedef struct _OGMRipWavPriv  OGMRipWavPriv;
typedef struct _OGMRipWavClass OGMRipWavClass;

struct _OGMRipWav
{
  OGMRipAudio parent_instance;

  OGMRipWavPriv *priv;
};

struct _OGMRipWavClass
{
  OGMRipAudioClass parent_class;
};

GType         ogmrip_wav_get_type   (void);
OGMJobSpawn * ogmrip_wav_new        (OGMDvdAudioStream *audio,
                                     const gchar       *output);
void          ogmrip_wav_set_header (OGMRipWav         *wav, 
                                     gboolean          header);
gboolean      ogmrip_wav_get_header (OGMRipWav         *wav);

G_END_DECLS

#endif /* __OGMRIP_WAV_H__ */

