/* OGMDvd - A wrapper library around libdvdread
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMDVD_TYPES_H__
#define __OGMDVD_TYPES_H__

#include <glib.h>

G_BEGIN_DECLS

typedef struct
{
  guint hour;
  guint min;
  guint sec;
  guint frames;
} OGMDvdTime;

#define OGMDVD_DISC(disc)          ((OGMDvdDisc *) (disc))

typedef struct _OGMDvdDisc        OGMDvdDisc;

#define OGMDVD_TITLE(title)        ((OGMDvdTitle *) (title))

typedef struct _OGMDvdTitle       OGMDvdTitle;

#define OGMDVD_STREAM(stream)      ((OGMDvdStream *) (stream))

typedef struct _OGMDvdStream      OGMDvdStream;

#define OGMDVD_AUDIO_STREAM(audio) ((OGMDvdAudioStream *) (audio))

typedef struct _OGMDvdAudioStream OGMDvdAudioStream;

#define OGMDVD_SUBP_STREAM(subp)   ((OGMDvdSubpStream *) (subp))

typedef struct _OGMDvdSubpStream  OGMDvdSubpStream;

G_END_DECLS

#endif /* __OGMDVD_TYPES_H__ */

