/* ============================================================
 * File  : streamconfig.cpp
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description : mythtv compatibility parts copied from mythnews
 *               plugin source, mythnews copyright Renchi Raju
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#ifndef STORAGECONFIG_H
#define STORAGECONFIG_H

#include <qsqldatabase.h>
#include <qdialog.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qvgroupbox.h>
#include <qtabwidget.h>
#include <qapplication.h>

#include "streamstorage.h"
#include "configelements.h"

#ifdef MYTHTV
#include <mythtv/mythdialogs.h>
#endif

class StorageEditGroup;
class StorageGroup;

#ifdef MYTHTV
typedef MythDialog BaseWidget;
typedef MythMainWindow BaseParent;
#else
typedef QWidget BaseWidget;
typedef QWidget BaseParent;
#endif


// repository tab
class StorageConfig : public BaseWidget
{
    Q_OBJECT

  public:
     StorageConfig(BaseParent *parent, const char *name, StreamStorage *streamStorage, ReposStorage *storageBin);
     ~StorageConfig();

     void setupView();
     void createStorage( ReposStorage::AccessType type, ValueList& values );
     void updateStorage( RepositoryItem* item, ValueList& values );
     void removeStorage(RepositoryItem* item);

   private slots:
     void itemSelected(QListViewItem* item);
     void slotStorageEvent(int ident, int eventType, bool error);

   private:
     QLabel *errorLabel;
     QListView *m_storageList;
     StorageEditGroup *storageEditGroup;
     ReposStorage *storage;
     StreamStorage *streams;
     RepositoryItem* activeItem;

     void reportMessage(const QString& error, bool bad);

  public slots:
    void slotRecordInserted(ChangedRecord *rec);
    void slotRecordUpdated(ChangedRecord *rec);
    void slotRecordRemoved(ChangedRecord *rec);
    void slotNewDbClicked();
    void slotNewFileClicked();
    void slotNewWebClicked();

  //private slots:
  //  void slotSitesViewExecuted(QListViewItem *item);
};


#endif /* STORAGECONFIG_H */
