/* liveice.h
 *
 * Copyright (c) 1999 Scott Manley, Barath Raghavan, Jack Moffitt, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License  
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
/* Gogo supports added by Steve j. Kodnik */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netdb.h>
#include <netinet/in.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <netdb.h>
#include <arpa/inet.h>   
#include <sched.h>       
#include <unistd.h>
#include <termios.h>
#include <sys/wait.h>
#include <ctype.h>

/* curses interface support */

#ifdef HAVE_LIBCURSES
#include <curses.h>
#endif

/* LiveIce Version Number - sent to servers and frontends to 
deal with format faviations */
#define LIVEICE_VERSION "1.0"



/* Soundcard support */
/* If you don't have OSS then you should comment out this line and you can 
   only run the system in mixer mode. */
#define SOUNDCARD_SUPPORT

/* big/little endian systems - probably needed for sparc and PPC */
/* Probably want to move this into config.h */
#define NUMBER_LITTLE_ENDIAN
/* #define NUMBER_BIG_ENDIAN */

/* undefine this and the programme will be less paranoid about checking 
   the pipes it uses for talking with the encoder  - this allows you to 
   substitute more robust pipe devices to talk to those 'difficult' encoders
   - you might want to check out my liveice pipe linux kernel module
*/
/*#define PARANOID_PIPES*/



/* Define one or the other to choose your favourite mp3 encoder */
/* l3enc requires teh *registered* version of l3enc */
/* mp3enc is again the registered version from Fraunhofer */
/* http://www.iis.fhg.de/amm/download/mp3enc/            */
/* AJ_ENCODER uses the optomised version of DIST10 by Andreas Johansson */
/* You can Download this from wopr.campus.luth.se:/pub/mpeg_layer_3     */
/* The quality produuced by the fraunhofer code is much better than */
/* that standard ISO sources - if you're at all serious about this radio */
/* business then you'll get some of their code which is the best that I've*/
/* found */
/* LAME 3.50 and above are the encoders of choice now - definately worth */
/* your time if you don't want to buy the fraunhofer codec               */

#define AJ_ENCODER       1
#define L3ENC            2
#define MP3ENC           3
#define BLADEENC         4
#define ENC_8HZ          5
#define SCREAMER         7
#define XING             8
#define XING_VBR         9
#define XING_BETA        10
/* gurr - there seem to be a few variations */
#define LAME3            11
#define LAME31x          12
#define OLD_LAME3        13
#define GOGO             14

#define DEFAULT_ENCODER LAME3

#define MAX_ENCODER_STREAMS 8

typedef enum
    {
    SOUNDCARD_MODE=0,
    MP3MIXER_MODE=1,
    ESDMON_MODE=2,
    COMMAND_MODE=3,
    SHOUT_MODE=4
    } MixerMode;

typedef enum
    {
    FE_CURSES=0,
    FE_PIPE=1,
    FE_NONE=2
    } FrontendType;

/* login formats */
#define ICY_LOGIN          0
#define X_AUDIOCAST_LOGIN  1

/* Default port */
#define PORT 8000

/* default bitrate and samplerate - differnet encoders need different settings*/

/* The Fraunhofer Codecs are best.... */
#if DEFAULT_ENCODER == L3ENC 
#define BITRATE 24000           
#define SAMPLE_RATE 22050       

#elif DEFAULT_ENCODER == MP3ENC
#define BITRATE 24000           
#define SAMPLE_RATE 22050       

/* Whie dist10 derived stuff is shite..... why doesnt' anyone fix LSF? */
#elif DEFAULT_ENCODER == AJ_ENCODER 
#define BITRATE 32000           
#define SAMPLE_RATE 32000      

/* Bladenc still doesn't work */
#elif DEFAULT_ENCODER == BLADEENC
#define BITRATE 64000           
#define SAMPLE_RATE 32000      

/* 8HZ might work... if I could get the source... */
#elif DEFAULT_ENCODER == ENC_8HZ 
#define BITRATE 32000           
#define SAMPLE_RATE 32000       

/* LAME needs hacked */
#elif DEFAULT_ENCODER == LAME3 
#define BITRATE 32000          
#define SAMPLE_RATE 22050    

/* LAME needs hacked */
#elif DEFAULT_ENCODER == OLD_LAME3 
#define BITRATE 32000           
#define SAMPLE_RATE 32000      

/* Isaac Richard has done it - Congratulations */
#elif DEFAULT_ENCODER == SCREAMER
#define BITRATE 24000           
#define SAMPLE_RATE 22050       

/* Xing Technologies mp3 encoder .... cheap, but not easy to run */
#elif DEFAULT_ENCODER == XING
#define BITRATE 24000           
#define SAMPLE_RATE 22050       

/* Xing, using the Variable bitrate codec */
#elif DEFAULT_ENCODER == XING_VBR
#define BITRATE 24000      
#define SAMPLE_RATE 22050       

/* Gogo - assembly optomised - fast... and occasionally a pain for me
but I like it anyway!
 */
#elif DEFAULT_ENCODER == GOGO
#define BITRATE 32000      
#define SAMPLE_RATE 22050       

#endif

/* VBR is only used by Xing right now - but Lame is almost there */
#define VBR_QUALITY 75

/* General tag to let people alter the output quality and perhaps save some time */
#define ENCODING_QUALITY 30

#define MP_BUFF_SIZE 4096  /* make sure this is large enough */


/* Magic numebrs for random number generator */
#define RAND_MOD  714025
#define RAND_MULT 4096
#define RAND_ADD  150889

/* communication details  - for shared memory page */
typedef struct Com_struct {
  int global_status;
  int tcp_status[MAX_ENCODER_STREAMS];
  int encoder_status[MAX_ENCODER_STREAMS];
  long bytes_sent[MAX_ENCODER_STREAMS];
} com_struct;


/* in theory we should be able to encode multiple streams */
/* need to work on the configuration system */
typedef struct Enc_struct {
	int enabled;           
	int port;
	char *server;
	char *password;
	char *mountpoint;
	char *name;
	char *genre;
	char *url;
	char *description;
      	char *sound_pipe;     /* name of pipe for sound processing */
	char *mpeg_pipe;      /* name of file used to store header */
	char *encoder_cmd;    /* possible string pointing to encoder bin */
	char *recording_file; /* recording file */
	char *remote_dumpfile; /* remote dumpfile */
        char *encoder_args;   /* extra command line options for the encoder */
	int public;
	int bitrate;
	int vbr_quality;
	int encoding_quality;
	int sample_rate;
	int stereo;
	int header_format;
	int copyright;
	int encoder;           /* enumed variable */
	FILE  *pipe;            /* file descriptor for writing to pipe */
	pid_t tcp;             /* child processes associated with stream */
	pid_t enc;             /* ditto */
} enc_struct;

/* this started out as a config structure being passed around - but it's
really now become a general scratchpad for all the data I need to keep 
track of I want to keep enerything in this structure so that I don't end up
confilicting with anythign else */
typedef struct{
	enc_struct e_str[MAX_ENCODER_STREAMS]; /* I know... static allocation..you do better*/
	int port;
	char *server;
	char *playlist;
	char *password;
	char *icy_name;
	char *icy_genre;
	char *icy_url;
	char *track_logfile;
        char *logfile_format;
        char *update_script;
	char *mountpoint;
	char *description;
	char *pipe_dir;       /* put exerything in a hidden dir... */
	char *recording_file;
	char *remote_dumpfile;
	char *sound_input_file; /* the file to read sound input from */
        char *random_content_id;
        char *encoder_args;
	int sound_device;     /* set to 1 if the sound file is a device */
	int icy_public;
	int bitrate;
	int vbr_quality;
	int encoding_quality;
	int sample_rate;
	int stereo;
	int audio_fd;         /* only one soundcard - only one audiofd */
	int full_duplex;
	int soundcard;         /* Are we using the soundcard? */
	char *decoder_cmd;
	int hacked_decoder;    /* are we using a hacked decoder? */
	int encoder;           /* enumed variable */
	char *encoder_cmd;    /* possible string pointing to encoder bin */
	int copyright;        /* try and mark stream as copyrighted */
	int debug;            /* debug level  higer => more messages */
	int rw_size;
	MixerMode mixer;      /* What kind of mixer? */
	char *mixer_cmd;	/* if mixer is COMMAND_MODE, then this is the command */
	/* now covering general Mode settings */
	int mix_control;      /* keyboard/logged keyboard/logfile */
	char *mix_control_file;   /* file for keylogging/control */
	int raw_fd;
	long random_seed;
	int header_format;         /* x-audiocast vs icy */
	int terminate_now;/* flag to remind processes thet they're terminted */
	FrontendType frontend; /* executed by a frontend ?*/
	time_t end_time;    /* on how long to broadcast for */
	int meta_data;     /* send meta_data repeat rate in minutes */
        
         /* shared memory pointer */
        com_struct *shm_data;

#ifdef HAVE_LIBCURSES
	WINDOW *icescreen;
	WINDOW *inputscreen;
	WINDOW *messagescreen;
	WINDOW *outputscreen;
#endif
} config;

config g_conf;           /*global configuration sturcture */


 

/* other functions */
void write_message(char *msg,int pri);
void fatal(char *text);
int valid(unsigned long); 
float random_number(long *irand);

int get_legal_rate(int rate);

void encoding(void);
void kill_children(int signo);
void alarm_timeout(int signo);
void arm(unsigned int secs);
void mp3mixer(void);

int write_streams(short *buf,int num);

void check_soundcard(void);
void open_soundcard(int flags);
void close_soundcard(void);

void synchronise_time(long samples);

int format_of (const char *filename,int *channels);

void set_interface(void);
void restore_interface(void);
void fix_interface(void);
void draw_simple_display(void);
void draw_mixer_display(void);
void draw_volume_meter(short *data,int num,int stereo);
void mv_draw_volume(int x,int y,int vol);

char get_inp_char();

void write_wav_header(FILE *outfile,int sample_rate,int stereo);

int spawn_encoder_process(enc_struct *e_stream);
int check_encoder_parameters(enc_struct *e_stream);

void update_all_servers (char *message,char *url);

void do_config(int argc, char *argv[]);


void do_simple_command(void);
/*int convert_audio(format *in,format *out,short *dat,int num);*/

