/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//#include <iostream.h>

#include <qpixmap.h>
#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kurl.h>
#include <kuser.h>
#include <kio/netaccess.h>

#include "kxmameSplash.h"
#include "kxmame.h"
#include "kxmamelogo.h"
#include "gxmame.h"

extern "C" {
#include <unistd.h>
#include <X11/Xlib.h>
}

kxmameSplashScreen *mSplashScreen;

static const char description[] =
    I18N_NOOP("A KDE frontend for X-M.A.M.E. and X-M.E.S.S.");

static const char version[] = VERSION;

int main(int argc, char **argv)
{
	//This is needed to fix the crash bug on closing due to some buggy X implementations.
	XInitThreads();
	KAboutData about("kxmame", I18N_NOOP("kxmame"), version, description,
			KAboutData::License_GPL, "(C) 2005 Nguyen The Toan", 0, "http://sourceforge.net/projects/kxmame/", "http://sourceforge.net/projects/kxmame/");
	about.addAuthor("Nguyen The Toan", 0, "nguyenthetoan@gmail.com" );
	about.addCredit("Avuton Olrich", "Fix 1001 bugs, CVS organization", 0, "avuton@gmail.com");
	about.addCredit("Vincenzo Reale", "Italian translation", 0, "smart2128@baslug.org");
	about.addCredit("Julian Sikorski", "Polish translation", 0,"lordzanon@poczta.onet.pl");
	about.addCredit("Marco Martin", "Improved search toolbar", 0,"notmart@gmail.com");
	about.addCredit("xmame team", "For an excellent emulator", 0, "http://x.mame.net");
	about.addCredit("gxmame team", "For an excellent xmame frontend. A major portion of kxmame source is based on gxmame source", 0, "http://sourceforge.net/projects/gxmame/");
	about.addCredit("Many people on kde-devel mailing list", "Various helps with KDE programming", 0, "http://www.kde.org");
	KCmdLineArgs::init(argc, argv, &about);
	KApplication app;
	
	mSplashScreen = new kxmameSplashScreen(kxmameLogo());
	mSplashScreen->setMessage(i18n("Initializing..."));
	mSplashScreen->show();
	kapp->processEvents();
	
	/* kxmame 2.x is not compatible with gxmame for user resource paths, we remove this code */
	
// 	KURL gxmameDir = KURL::fromPathOrURL(KUser().homeDir()), kxmameDir = gxmameDir;
// 	gxmameDir.addPath(".gxmame");
// 	kxmameDir.addPath(DOT_GXMAME);
// 	
// 	// if $HOME/.kxmame doesn't exist and .gxmame exists
// 	// we copy .gxmame to .kxmame	
// 	if ((!KIO::NetAccess::exists(kxmameDir, TRUE, 0)) && 
// 		     (KIO::NetAccess::exists(gxmameDir, TRUE, 0))) {
// 		mSplashScreen->setMessage(i18n("Importing GXmame configuration..."));
// 		kapp->processEvents();
// 		//Because KIO::NetAccess::dircopy does its job in
// 		// the background, it's possible that, on slow machine, the copy job is
// 		// not finished before gxmame_init() is called. For safety, we move .gxmame
// 		// to .kxmame first, then copy files back to .gxmame.
// 		KIO::NetAccess::move(gxmameDir, kxmameDir,0); // move .gxmame to .kxmame
// 		sleep(1); // Should give enough time for the move to complete.
// 		KIO::NetAccess::dircopy(kxmameDir, gxmameDir, 0); // copy .kxmame to .gxmame
// 	}
// 	gxmameDir = kxmameDir = KURL();

#if KDE_IS_VERSION(3,4,0)
	QPixmap mLogo = QPixmap("kxmame_64.png");
	about.setProgramLogo(mLogo.convertToImage());
#endif

	// see if we are starting with session management
	if (app.isRestored())
	{
		RESTORE(kxmame);
	}
	else
	{
		// no session.. just start up normally
		//KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		kxmame *widget = new kxmame;
		widget->show();
		//args->clear();
	}
	
	delete mSplashScreen;
	mSplashScreen = NULL;
	
	return app.exec();
}
