/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)ShutdownHandler.java	1.37 06/28/07
 */ 

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.resources.*;

//XXX:Audit:Removed
//import com.sun.messaging.jmq.jmsserver.audit.MQAuditSession;

import com.sun.messaging.jmq.util.ServiceType;



public class ShutdownHandler extends AdminCmdHandler
{
    private static boolean DEBUG = getDEBUG();

    public ShutdownHandler(AdminDataHandler parent) {
	super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                "Shutting down broker: " + cmd_props);
        }


        boolean shouldRestart = true;
        Boolean noFailover = null;
        Integer time = null;

	// Send reply
	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

        if (Broker.isInProcess()) {
	     String error = rb.getString(rb.E_CANNOT_SHUTDOWN_IN_PROCESS);
	     setProperties(reply, MessageType.SHUTDOWN_REPLY, Status.ERROR, error);
	     parent.sendReply(con, cmd_msg, reply);
             return true;
            
        }
	setProperties(reply, MessageType.SHUTDOWN_REPLY, Status.OK, null);


        try {

	    // See if we're supposed to clobber ourselves.
	    Boolean kill = (Boolean)cmd_props.get(MessageType.JMQ_KILL);
	    if (kill != null && kill.booleanValue()) {
	        // Unsafe exit. Used for testing. Remove shutdown hook then exit.
	        Broker.getBroker().removeShutdownHook(Broker.getBroker().shutdownHook);
	        System.exit(1);
	    }


	    noFailover = (Boolean)cmd_props.get(MessageType.JMQ_NO_FAILOVER);
	    time = (Integer)cmd_props.get(MessageType.JMQ_TIME);
	    Boolean restart = (Boolean)cmd_props.get(MessageType.JMQ_RESTART);
            shouldRestart =
		    (restart == null ? false : restart.booleanValue());
            if (shouldRestart) noFailover=Boolean.TRUE;

	    /*
	     * Value of -nofailover and -time from imqcmd is encapsulated
	     * in 'noFailover' and 'time'. Note that these values can be
	     * null.
	     *
            logger.log(Logger.INFO, "ShutdownHandler: noFailover: " + noFailover);
            logger.log(Logger.INFO, "ShutdownHandler: time: " + time);
	     */


//XXX:Audit:Removed
//	    // audit logging for broker restart/shutdown
//	    Globals.getAuditSession().brokerOperation(
//			con.getUserName(), con.remoteHostString(),
//			shouldRestart ? MQAuditSession.BROKER_RESTART :
//					MQAuditSession.BROKER_SHUTDOWN);


            // stop taking new requests
            Globals.getServiceManager().stopNewConnections(
                  ServiceType.NORMAL);

            if (time == null || time.intValue() == 0)
                Globals.getServiceManager().stopNewConnections(
                      ServiceType.ADMIN);

        } catch (Exception ex)  {
            logger.logStack(Logger.WARNING,
                BrokerResources.E_INTERNAL_BROKER_ERROR,
                "unable to shutdown", ex);
        } finally {


            // send the reply to client that we received the request
            //
            // currently, we never send an error on shutdown
            //
	    parent.sendReply(con, cmd_msg, reply);
	    if (con instanceof IMQIPConnection)  {
	        IMQIPConnection ipCon = (IMQIPConnection)con;
                ipCon.flushControl(1000);
	    }

            BrokerStateHandler bsh = Globals.getBrokerStateHandler();
            // set the flag to notify everyone we are shutting down
            //

            // stop new connections
            //
            boolean failover = (noFailover == null ? true
                                : !(noFailover.booleanValue()));

            if (time == null || time.intValue() == 0) {
                bsh.shuttingDown = true;
                bsh.prepareShutdown(failover);
            }

            /**
             * if we arent doing an unsafe exit, give us time to complete
             * any operations
             */
            waitForHandlersToComplete(20);


            if (shouldRestart) {
                logger.log(Logger.INFO, rb.I_ADMIN_RESTART_REQUEST);
            } else {
                logger.log(Logger.INFO, rb.I_ADMIN_SHUTDOWN_REQUEST);
            }
            // stop shutdown the broker 
            bsh.initiateShutdown(
                       "admin", 
                       (time == null ? 0 : time.longValue())* 1000, 
                        failover, (shouldRestart ?
                        bsh.getRestartCode() : 0), true);
                        
        }
        return true;
    }
}
