/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;

public class ClusterGoodbyeInfo {
    private boolean requestTakeover = false;
    private Cluster c = null;
    private GPacket pkt = null;
    private BrokerAddress sender = null;

    private ClusterGoodbyeInfo(boolean bl, Cluster cluster) {
        this.requestTakeover = bl;
        this.c = cluster;
    }

    private ClusterGoodbyeInfo(GPacket gPacket, Cluster cluster) throws Exception {
        assert (gPacket.getType() == 37);
        this.pkt = gPacket;
        this.c = cluster;
        this.sender = cluster.unmarshalBrokerAddress(gPacket);
        if (this.sender.getHAEnabled()) {
            this.requestTakeover = (Boolean)gPacket.getProp("requestTakeover");
        }
    }

    public static ClusterGoodbyeInfo newInstance(boolean bl, Cluster cluster) {
        return new ClusterGoodbyeInfo(bl, cluster);
    }

    public static ClusterGoodbyeInfo newInstance(Cluster cluster) {
        return new ClusterGoodbyeInfo(false, cluster);
    }

    public static ClusterGoodbyeInfo newInstance(GPacket gPacket, Cluster cluster) throws Exception {
        return new ClusterGoodbyeInfo(gPacket, cluster);
    }

    public GPacket getGPacket() {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)37);
        gPacket.setBit(1, true);
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
        if (this.c.getSelfAddress().getHAEnabled()) {
            gPacket.putProp("requestTakeover", this.requestTakeover);
        }
        return gPacket;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public String toString() {
        if (this.pkt == null) {
            if (Globals.getHAEnabled()) {
                return "requestTakeover=" + this.requestTakeover + " " + this.c.getSelfAddress().toString();
            }
            return this.c.getSelfAddress().toString();
        }
        if (this.sender.getHAEnabled()) {
            return "requestTakeover=" + this.requestTakeover + " " + this.sender.toString();
        }
        return this.sender.toString();
    }

    public static GPacket getReplyGPacket(int n) {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)38);
        gPacket.putProp("S", new Integer(n));
        return gPacket;
    }
}

