/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.heartbeat;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class HeartbeatInfo {
    public static final short HEARTBEAT_ALIVE = 1;
    public static final int HEARTBEAT_PROTOCOL_VERSION = 400;
    private String brokerID = null;
    private long brokerSession = 0L;
    private BrokerMQAddress brokerAddress = null;
    private String toBrokerID = null;
    private long toBrokerSession = 0L;
    private long sequence = 0L;
    private GPacket pkt = null;

    private HeartbeatInfo(GPacket gPacket) {
        this.pkt = gPacket;
    }

    private HeartbeatInfo() {
    }

    public static HeartbeatInfo newInstance() {
        return new HeartbeatInfo();
    }

    public static HeartbeatInfo newInstance(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GPacket gPacket = GPacket.getInstance();
        gPacket.read(byteArrayInputStream);
        int n = (Integer)gPacket.getProp("protocolVersion");
        if (n < 400) {
            throw new IOException("Protocol version not supported:" + n);
        }
        return new HeartbeatInfo(gPacket);
    }

    public GPacket getGPacket() {
        GPacket gPacket = GPacket.getInstance();
        gPacket.generateSequenceNumber(false);
        gPacket.setType((short)1);
        gPacket.setSequence(this.sequence);
        gPacket.putProp("protocolVersion", new Integer(400));
        gPacket.putProp("brokerID", this.brokerID);
        gPacket.putProp("brokerSession", new Long(this.brokerSession));
        gPacket.putProp("brokerAddress", this.brokerAddress.toString());
        gPacket.putProp("toBrokerID", this.toBrokerID);
        gPacket.putProp("toBrokerSession", new Long(this.toBrokerSession));
        return gPacket;
    }

    public static byte[] toByteArray(GPacket gPacket) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setBrokerID(String string) {
        this.brokerID = string;
    }

    public void setBrokerSession(long l) {
        this.brokerSession = l;
    }

    public void setBrokerAddress(BrokerMQAddress brokerMQAddress) {
        this.brokerAddress = brokerMQAddress;
    }

    public void setToBrokerID(String string) {
        this.toBrokerID = string;
    }

    public void setToBrokerSession(long l) {
        this.toBrokerSession = l;
    }

    public void setSequence(long l) {
        this.sequence = l;
    }

    public String getBrokerID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("brokerID");
    }

    public long getBrokerSession() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("brokerSession");
    }

    public String getToBrokerID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("toBrokerID");
    }

    public long getToBrokerSession() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("toBrokerSession");
    }

    public long getSequence() {
        assert (this.pkt != null);
        return this.pkt.getSequence();
    }

    public String toString() {
        if (this.pkt != null) {
            return "#" + this.getSequence() + " [" + this.getBrokerID() + "," + this.getBrokerSession() + "] to " + "[" + this.getToBrokerID() + "," + this.getToBrokerSession() + "]";
        }
        return "[" + this.brokerID + "," + this.brokerSession + "] to " + "[" + this.toBrokerID + "," + this.toBrokerSession + "]";
    }
}

