/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ServiceUtil;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class ServiceConfig
extends MQMBeanReadWrite
implements ConfigListener {
    private String service = null;
    private Properties brokerProps = null;
    private boolean propsStale = true;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public ServiceConfig(String string) {
        this.service = string;
        this.initProps();
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.addListener(this.getThreadModelPropName(), this);
        brokerConfig.addListener(this.getMaxThreadsPropName(), this);
        brokerConfig.addListener(this.getMinThreadsPropName(), this);
        brokerConfig.addListener(this.getPortPropName(), this);
    }

    public void setMaxThreads(Integer n) throws MBeanException {
        try {
            this.updateService(-1, -1, n);
        }
        catch (Exception exception) {
            this.handleSetterException("MaxThreads", exception);
        }
    }

    public Integer getMaxThreads() throws MBeanException {
        this.initProps();
        String string = this.brokerProps.getProperty(this.getMaxThreadsPropName());
        Integer n = null;
        try {
            if (string != null) {
                n = new Integer(string);
            }
        }
        catch (Exception exception) {
            this.handleGetterException("MaxThreads", exception);
        }
        return n;
    }

    private String getMaxThreadsPropName() {
        return "imq." + this.getName() + ".max_threads";
    }

    public void setMinThreads(Integer n) throws MBeanException {
        try {
            this.updateService(-1, n, -1);
        }
        catch (Exception exception) {
            this.handleSetterException("MinThreads", exception);
        }
    }

    public Integer getMinThreads() throws MBeanException {
        this.initProps();
        String string = this.brokerProps.getProperty(this.getMinThreadsPropName());
        Integer n = null;
        try {
            if (string != null) {
                n = new Integer(string);
            }
        }
        catch (Exception exception) {
            this.handleGetterException("MinThreads", exception);
        }
        return n;
    }

    private String getMinThreadsPropName() {
        return "imq." + this.getName() + ".min_threads";
    }

    public String getName() {
        return this.service;
    }

    public void setPort(Integer n) throws MBeanException {
        try {
            this.updateService(n, -1, -1);
        }
        catch (Exception exception) {
            this.handleSetterException("Port", exception);
        }
    }

    public Integer getPort() throws MBeanException {
        this.initProps();
        String string = this.brokerProps.getProperty(this.getPortPropName());
        Integer n = null;
        try {
            if (string != null) {
                n = new Integer(string);
            }
        }
        catch (Exception exception) {
            this.handleGetterException("Port", exception);
        }
        return n;
    }

    private String getPortPropName() {
        String string = this.brokerProps.getProperty("imq." + this.getName() + ".protocoltype");
        return "imq." + this.getName() + "." + string + ".port";
    }

    public String getThreadPoolModel() {
        return this.brokerProps.getProperty(this.getThreadModelPropName());
    }

    private String getThreadModelPropName() {
        return "imq." + this.getName() + ".threadpool_model";
    }

    public void pause() throws MBeanException {
        try {
            if (this.isAdminService()) {
                throw new BrokerException("Cannot pause admin service: " + this.service);
            }
            this.logger.log(8, "B1124", this.service);
            ServiceUtil.pauseService(this.service);
        }
        catch (BrokerException brokerException) {
            this.handleOperationException("pause", brokerException);
        }
    }

    public void resume() throws MBeanException {
        try {
            if (this.isAdminService()) {
                throw new BrokerException("Cannot resume admin service: " + this.service);
            }
            this.logger.log(8, "B1128", this.service);
            ServiceUtil.resumeService(this.service);
        }
        catch (BrokerException brokerException) {
            this.handleOperationException("resume", brokerException);
        }
    }

    private boolean isAdminService() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        if (serviceInfo == null) {
            return false;
        }
        return serviceInfo.type == 1;
    }

    public String getMBeanName() {
        return "ServiceConfig";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1192");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
    }

    public boolean update(String string, String string2) {
        Integer n = null;
        Integer n2 = null;
        if (string.equals(this.getMaxThreadsPropName())) {
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of " + "MaxThreads" + ": " + numberFormatException);
                n = null;
            }
            try {
                n2 = this.getMaxThreads();
            }
            catch (Exception exception) {
                this.logProblemGettingOldVal("MaxThreads", exception);
                n2 = null;
            }
            this.notifyAttrChange("MaxThreads", n, n2);
            this.propsStale = true;
        } else if (string.equals(this.getMinThreadsPropName())) {
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of " + "MinThreads" + ": " + numberFormatException);
                n = null;
            }
            try {
                n2 = this.getMinThreads();
            }
            catch (Exception exception) {
                this.logProblemGettingOldVal("MinThreads", exception);
                n2 = null;
            }
            this.notifyAttrChange("MinThreads", n, n2);
            this.propsStale = true;
        } else if (string.equals(this.getPortPropName())) {
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of " + "Port" + ": " + numberFormatException);
                n = null;
            }
            try {
                n2 = this.getPort();
            }
            catch (Exception exception) {
                this.logProblemGettingOldVal("Port", exception);
                n2 = null;
            }
            this.notifyAttrChange("Port", n, n2);
            this.propsStale = true;
        }
        return true;
    }

    public void notifyAttrChange(String string, Object object, Object object2) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", string, object == null ? "" : object.getClass().getName(), object2, object));
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.notifyServiceAttrUpdated(this.getName(), string, object2, object);
        }
    }

    private void updateService(int n, int n2, int n3) throws IOException, PropertyUpdateException, BrokerException {
        ServiceManager serviceManager = Globals.getServiceManager();
        Service service = serviceManager.getService(this.getName());
        if (service == null) {
            throw new BrokerException(rb.getString("B4057", this.getName()));
        }
        if (!(service instanceof IMQService)) {
            throw new BrokerException("Internal Error: can updated non-standard Service");
        }
        IMQService iMQService = (IMQService)service;
        iMQService.updateService(n, n2, n3);
    }

    private void initProps() {
        if (!this.propsStale) {
            return;
        }
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
        this.propsStale = false;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[5];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("MaxThreads", Integer.class.getName(), mbr.getString("MB1193"), true, true, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("MinThreads", Integer.class.getName(), mbr.getString("MB1194"), true, true, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("Name", String.class.getName(), mbr.getString("MB1195"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("Port", Integer.class.getName(), mbr.getString("MB1196"), true, true, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("ThreadPoolModel", String.class.getName(), mbr.getString("MB1197"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[2];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("pause", mbr.getString("MB1214"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("resume", mbr.getString("MB1215"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

