/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.LogUtil;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class LogConfig
extends MQMBeanReadWrite
implements ConfigListener {
    private Properties brokerProps = null;
    private static MBeanAttributeInfo[] attrs;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public LogConfig() {
        this.initProps();
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.addListener("imq.log.level", this);
        brokerConfig.addListener("imq.log.file.rolloverbytes", this);
        brokerConfig.addListener("imq.log.file.rolloversecs", this);
    }

    public void setLevel(String string) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.log.level", LogUtil.toInternalLogLevel(string));
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("Level", exception);
        }
    }

    public String getLevel() {
        String string = this.brokerProps.getProperty("imq.log.level");
        return LogUtil.toExternalLogLevel(string);
    }

    public void setRolloverBytes(Long l) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.log.file.rolloverbytes", l.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("RolloverBytes", exception);
        }
    }

    public Long getRolloverBytes() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.log.file.rolloverbytes");
        Long l = null;
        try {
            l = new Long(string);
        }
        catch (Exception exception) {
            this.handleGetterException("RolloverBytes", exception);
        }
        return l;
    }

    public void setRolloverSecs(Long l) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.log.file.rolloversecs", l.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("RolloverSecs", exception);
        }
    }

    public Long getRolloverSecs() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.log.file.rolloversecs");
        Long l = null;
        try {
            l = new Long(string);
        }
        catch (Exception exception) {
            this.handleGetterException("RolloverSecs", exception);
        }
        return l;
    }

    public String getMBeanName() {
        return "LogConfig";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1135");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return null;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
    }

    public boolean update(String string, String string2) {
        if (string.equals("imq.log.level")) {
            String string3 = LogUtil.toExternalLogLevel(string2);
            String string4 = this.getLevel();
            this.notifyAttrChange("Level", string3, string4);
        } else if (string.equals("imq.log.file.rolloverbytes")) {
            Long l;
            Long l2;
            try {
                l2 = Long.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of " + "RolloverBytes" + ": " + numberFormatException);
                l2 = null;
            }
            try {
                l = this.getRolloverBytes();
            }
            catch (Exception exception) {
                this.logProblemGettingOldVal("RolloverBytes", exception);
                l = null;
            }
            this.notifyAttrChange("RolloverBytes", l2, l);
        } else if (string.equals("imq.log.file.rolloversecs")) {
            Long l;
            Long l3;
            try {
                l3 = Long.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of " + "RolloverSecs" + ": " + numberFormatException);
                l3 = null;
            }
            try {
                l = this.getRolloverSecs();
            }
            catch (Exception exception) {
                this.logProblemGettingOldVal("RolloverSecs", exception);
                l = null;
            }
            this.notifyAttrChange("RolloverSecs", l3, l);
        }
        this.initProps();
        return true;
    }

    public void notifyAttrChange(String string, Object object, Object object2) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", string, object == null ? "" : object.getClass().getName(), object2, object));
    }

    private void initProps() {
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[3];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("Level", String.class.getName(), mbr.getString("MB1136"), true, true, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("RolloverBytes", Long.class.getName(), mbr.getString("MB1137"), true, true, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("RolloverSecs", Long.class.getName(), mbr.getString("MB1138"), true, true, false);
        attrs = mBeanAttributeInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

