/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class ConnectionMonitor
extends MQMBeanReadOnly {
    private long id;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;

    public ConnectionMonitor(long l) {
        this.id = l;
    }

    public String getClientID() {
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(this.id);
        return connectionInfo.clientID;
    }

    public String getClientPlatform() {
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(this.id);
        return connectionInfo.userAgent;
    }

    public String getConnectionID() {
        return Long.toString(this.id);
    }

    public String getHost() {
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(this.id);
        String string = null;
        if (connectionInfo.remoteIP != null) {
            string = String.valueOf(IPAddress.rawIPToString(connectionInfo.remoteIP, true, true));
        }
        return string;
    }

    public Integer getNumConsumers() {
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(this.id);
        return new Integer(connectionInfo.nconsumers);
    }

    public Integer getNumProducers() {
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(this.id);
        return new Integer(connectionInfo.nproducers);
    }

    public Integer getPort() {
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(this.id);
        return new Integer(connectionInfo.remPort);
    }

    public ObjectName getService() throws MBeanException {
        String string = ConnectionUtil.getServiceOfConnection(this.id);
        ObjectName objectName = null;
        try {
            objectName = MQObjectName.createServiceMonitor(string);
        }
        catch (Exception exception) {
            this.handleOperationException("getService", exception);
        }
        return objectName;
    }

    public String getServiceName() {
        String string = ConnectionUtil.getServiceOfConnection(this.id);
        return string;
    }

    public String getUser() {
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(this.id);
        return connectionInfo.user;
    }

    public String[] getConsumerIDs() throws MBeanException {
        List list = ConnectionUtil.getConsumerIDs(this.id);
        if (list == null || list.size() == 0) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ConsumerUID consumerUID = (ConsumerUID)iterator.next();
            long l = consumerUID.longValue();
            try {
                String string;
                stringArray[n] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getConsumerIDs", exception);
            }
            ++n;
        }
        return stringArray;
    }

    public String[] getProducerIDs() throws MBeanException {
        List list = ConnectionUtil.getProducerIDs(this.id);
        if (list == null || list.size() == 0) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ProducerUID producerUID = (ProducerUID)iterator.next();
            long l = producerUID.longValue();
            try {
                String string;
                stringArray[n] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getProducerIDs", exception);
            }
            ++n;
        }
        return stringArray;
    }

    public ObjectName[] getTemporaryDestinations() throws MBeanException {
        List list = DestinationUtil.getVisibleTemporaryDestinations(this.id);
        if (list.size() == 0) {
            return null;
        }
        ObjectName[] objectNameArray = new ObjectName[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Destination destination = (Destination)list.get(i);
            try {
                ObjectName objectName;
                objectNameArray[i] = objectName = MQObjectName.createDestinationMonitor(destination.isQueue() ? "q" : "t", destination.getDestinationName());
                continue;
            }
            catch (Exception exception) {
                this.handleOperationException("getTemporaryDestinations", exception);
            }
        }
        return objectNameArray;
    }

    public String getMBeanName() {
        return "ConnectionMonitor";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1057");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[9];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("ClientID", String.class.getName(), mbr.getString("MB1044"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("ClientPlatform", String.class.getName(), mbr.getString("MB1045"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("ConnectionID", String.class.getName(), mbr.getString("MB1046"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("Host", String.class.getName(), mbr.getString("MB1047"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("NumConsumers", Integer.class.getName(), mbr.getString("MB1048"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("NumProducers", Integer.class.getName(), mbr.getString("MB1049"), true, false, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("Port", Integer.class.getName(), mbr.getString("MB1050"), true, false, false);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("ServiceName", String.class.getName(), mbr.getString("MB1051"), true, false, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("User", String.class.getName(), mbr.getString("MB1052"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[4];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1053"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getProducerIDs", mbr.getString("MB1054"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getService", mbr.getString("MB1055"), null, ObjectName.class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getTemporaryDestinations", mbr.getString("MB1056"), null, ObjectName[].class.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

