/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.net.tls.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.KeystoreUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class MQRMIServerSocketFactory
extends SslRMIServerSocketFactory {
    private static SSLServerSocketFactory ssfactory = null;
    private static final Object classlock = new Object();
    private String jmxHostname = null;
    private int backlog = 0;
    private boolean useSSL = false;
    protected static final Logger logger = Globals.getLogger();
    protected static final BrokerResources br = Globals.getBrokerResources();

    public MQRMIServerSocketFactory(String string, int n, boolean bl) {
        this.jmxHostname = string;
        this.backlog = n;
        this.useSSL = bl;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        ServerSocket serverSocket = null;
        if (this.useSSL) {
            SSLServerSocketFactory sSLServerSocketFactory = (SSLServerSocketFactory)MQRMIServerSocketFactory.getSSLServerSocketFactory();
            if (this.jmxHostname != null && !this.jmxHostname.equals("*")) {
                InetAddress inetAddress = Globals.getJMXInetAddress();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
                serverSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket();
                serverSocket.setReuseAddress(true);
                serverSocket.bind(inetSocketAddress, this.backlog);
            } else {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(n);
                serverSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket();
                serverSocket.setReuseAddress(true);
                serverSocket.bind(inetSocketAddress, this.backlog);
            }
        } else if (this.jmxHostname != null && !this.jmxHostname.equals("*")) {
            InetAddress inetAddress = Globals.getJMXInetAddress();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
            serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(inetSocketAddress, this.backlog);
        } else {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(n);
            serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(inetSocketAddress, this.backlog);
        }
        return serverSocket;
    }

    public String toString() {
        return "jmxHostname=" + this.jmxHostname + ",backlog=" + this.backlog + ",useSSL=" + this.useSSL;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MQRMIServerSocketFactory)) {
            return false;
        }
        MQRMIServerSocketFactory mQRMIServerSocketFactory = (MQRMIServerSocketFactory)object;
        if (this.jmxHostname != null ? mQRMIServerSocketFactory.jmxHostname == null || !mQRMIServerSocketFactory.jmxHostname.equals(this.jmxHostname) : mQRMIServerSocketFactory.jmxHostname != null) {
            return false;
        }
        if (this.backlog != mQRMIServerSocketFactory.backlog) {
            return false;
        }
        return this.useSSL == mQRMIServerSocketFactory.useSSL;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerSocketFactory getSSLServerSocketFactory() throws IOException {
        Object object = classlock;
        synchronized (object) {
            if (ssfactory == null) {
                try {
                    String string = KeystoreUtil.getKeystoreLocation();
                    File file = new File(string);
                    if (!file.exists()) {
                        throw new IOException(br.getKString("B3019", string));
                    }
                    String string2 = KeystoreUtil.getKeystorePassword();
                    if (string2 == null) {
                        string2 = "";
                        logger.log(32, br.getKString("B3021"));
                    }
                    char[] cArray = string2.toCharArray();
                    SSLContext sSLContext = SSLContext.getInstance("TLS");
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(new FileInputStream(string), cArray);
                    keyManagerFactory.init(keyStore, cArray);
                    TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
                    SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                    sSLContext.init(keyManagerFactory.getKeyManagers(), null, secureRandom);
                    ssfactory = sSLContext.getServerSocketFactory();
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new IOException(exception.toString());
                }
            }
            return ssfactory;
        }
    }
}

