/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.MQAuthenticator;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetClusterHandler;
import com.sun.messaging.jmq.jmsserver.management.agent.ConnectorServerManager;
import com.sun.messaging.jmq.jmsserver.management.agent.JesmfManager;
import com.sun.messaging.jmq.jmsserver.management.agent.MQRMIServerSocketFactory;
import com.sun.messaging.jmq.jmsserver.management.mbeans.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ClusterMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ConnectionConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ConnectionManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ConnectionMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ConsumerManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.DestinationConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.DestinationManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.DestinationMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.LogMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MessageManagerConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MessageManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ProducerManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ServiceConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ServiceManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ServiceMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.TransactionManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.jmsserver.management.util.ServiceUtil;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.io.Serializable;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.loading.MLet;

public class Agent {
    private static boolean DEBUG = Globals.getConfig().getBooleanProperty("imq.jmx.debug.all");
    private static String JMX_PROPBASE = "imq.jmx";
    private static String ENABLED = JMX_PROPBASE + ".enabled";
    private static String USE_PLATFORM_MBEANSERVER = JMX_PROPBASE + ".usePlatformMBeanServer";
    private static String MSG_MBEANS_ENABLED = JMX_PROPBASE + ".mbeans.msg.enabled";
    private static String MLET_ENABLED = JMX_PROPBASE + ".mlet.enabled";
    private static String MLET_FILE_URL = JMX_PROPBASE + ".mlet.file.url";
    private static String RMIREGISTRY_PROPBASE = JMX_PROPBASE + ".rmiregistry";
    private static String RMIREGISTRY_START = RMIREGISTRY_PROPBASE + ".start";
    private static String RMIREGISTRY_USE = RMIREGISTRY_PROPBASE + ".use";
    private static String RMIREGISTRY_PORT = RMIREGISTRY_PROPBASE + ".port";
    private MBeanServer mbs = null;
    private ConnectorServerManager csm = null;
    private Logger logger = null;
    private boolean active = false;
    private com.sun.messaging.jmq.jmsserver.config.BrokerConfig config = Globals.getConfig();
    private BrokerResources rb = null;
    private MQAuthenticator authenticator = null;
    private String mbeansPkgName = "com.sun.messaging.jmq.jmsserver.management.mbeans";
    private String[][] oneOnlyMBeans = new String[][]{{"JVMMonitor", "com.sun.messaging.jms.server:type=JVM,subtype=Monitor"}, {"BrokerConfig", "com.sun.messaging.jms.server:type=Broker,subtype=Config"}, {"ServiceManagerConfig", "com.sun.messaging.jms.server:type=ServiceManager,subtype=Config"}, {"DestinationManagerConfig", "com.sun.messaging.jms.server:type=DestinationManager,subtype=Config"}, {"ConnectionManagerConfig", "com.sun.messaging.jms.server:type=ConnectionManager,subtype=Config"}, {"ConsumerManagerConfig", "com.sun.messaging.jms.server:type=ConsumerManager,subtype=Config"}, {"ProducerManagerConfig", "com.sun.messaging.jms.server:type=ProducerManager,subtype=Config"}, {"TransactionManagerConfig", "com.sun.messaging.jms.server:type=TransactionManager,subtype=Config"}, {"ClusterConfig", "com.sun.messaging.jms.server:type=Cluster,subtype=Config"}, {"LogConfig", "com.sun.messaging.jms.server:type=Log,subtype=Config"}};
    private Map mbeans = Collections.synchronizedMap(new HashMap());
    private BrokerMonitor bkrMon;
    private ServiceManagerMonitor svcMgrMon;
    private ConnectionManagerMonitor cxnMgrMon;
    private DestinationManagerMonitor dstMgrMon;
    private ConsumerManagerMonitor conMgrMon;
    private ProducerManagerMonitor prdMgrMon;
    private TransactionManagerMonitor txnMgrMon;
    private ClusterMonitor clsMon;
    private LogMonitor logMon;
    private MessageManagerConfig msgMgrCon;
    private MessageManagerMonitor msgMgrMon;
    private MLet mqMLet = null;
    private String MQMLET_MBEAN_NAME = "com.sun.messaging.jms.server:type=MQMLet";
    private String MESSAGE_MANAGER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=MessageManager,subtype=Config";
    private String MESSAGE_MANAGER_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=MessageManager,subtype=Monitor";
    ClusterListener cl = new ClusterStateListener();
    JesmfManager jesmfMgr = null;

    public Agent() {
        this.init();
    }

    public void destroy() {
        Globals.getClusterManager().removeEventListener(this.cl);
    }

    public boolean isActive() {
        return this.active;
    }

    public void start() {
        if (!this.isActive()) {
            return;
        }
        try {
            this.csm.start();
        }
        catch (Exception exception) {
            this.logger.log(16, "B2137");
        }
    }

    public void stop() {
        if (!this.isActive()) {
            return;
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.stop();
        }
        try {
            this.csm.stop();
        }
        catch (Exception exception) {
            this.logger.log(16, "B2138", exception);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public JesmfManager getJesmfManager() {
        return this.jesmfMgr;
    }

    public boolean useRmiRegistry() {
        return this.config.getBooleanProperty(RMIREGISTRY_USE);
    }

    public boolean msgMBeansEnabled() {
        return this.config.getBooleanProperty(MSG_MBEANS_ENABLED);
    }

    public boolean mletEnabled() {
        return this.config.getBooleanProperty(MLET_ENABLED);
    }

    public String getMLetFileURL() {
        return this.config.getProperty(MLET_FILE_URL);
    }

    public boolean startRmiRegistry() {
        return this.config.getBooleanProperty(RMIREGISTRY_START);
    }

    public int getRmiRegistryPort() {
        int n = this.config.getIntProperty(RMIREGISTRY_PORT, 0);
        if (n == 0) {
            n = 1099;
        }
        return n;
    }

    public ConnectorServerManager getConnectorServerManager() {
        return this.csm;
    }

    public MQAuthenticator getMQAuthenticator() {
        if (this.authenticator == null) {
            try {
                this.authenticator = new MQAuthenticator("admin", 1);
            }
            catch (Exception exception) {
                String string = this.rb.getString("B2172", exception.toString());
                this.logger.log(16, string);
            }
        }
        return this.authenticator;
    }

    public void registerDestination(Destination destination) {
        ObjectName objectName;
        if (!this.isActive()) {
            return;
        }
        if (!DestinationUtil.isVisibleDestination(destination)) {
            return;
        }
        try {
            DestinationMonitor destinationMonitor = new DestinationMonitor(destination);
            objectName = MQObjectName.createDestinationMonitor(destination.isQueue() ? "q" : "t", destination.getDestinationName());
            this.agentRegisterMBean(destinationMonitor, objectName);
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2139", "Destination Monitor"), exception);
        }
        try {
            DestinationConfig destinationConfig = new DestinationConfig(destination);
            objectName = MQObjectName.createDestinationConfig(destination.isQueue() ? "q" : "t", destination.getDestinationName());
            this.agentRegisterMBean(destinationConfig, objectName);
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2139", "Destination Config"), exception);
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.registerDestination(destination);
        }
    }

    public void unregisterDestination(Destination destination) {
        ObjectName objectName;
        if (!this.isActive()) {
            return;
        }
        if (!DestinationUtil.isVisibleDestination(destination)) {
            return;
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.unregisterDestination(destination);
        }
        try {
            objectName = MQObjectName.createDestinationMonitor(destination.isQueue() ? "q" : "t", destination.getDestinationName());
            this.agentUnregisterMBean(objectName);
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2140", "Destination Monitor"), exception);
        }
        try {
            objectName = MQObjectName.createDestinationConfig(destination.isQueue() ? "q" : "t", destination.getDestinationName());
            this.agentUnregisterMBean(objectName);
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2140", "Destination Config"), exception);
        }
    }

    public void registerService(String string) {
        ObjectName objectName;
        if (!this.isActive()) {
            return;
        }
        try {
            ServiceMonitor serviceMonitor = new ServiceMonitor(string);
            objectName = MQObjectName.createServiceMonitor(string);
            this.agentRegisterMBean(serviceMonitor, objectName);
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2139", "Service Monitor"), exception);
        }
        try {
            ServiceConfig serviceConfig = new ServiceConfig(string);
            objectName = MQObjectName.createServiceConfig(string);
            this.agentRegisterMBean(serviceConfig, objectName);
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2139", "Service Config"), exception);
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.registerService(string);
        }
    }

    public void unregisterService(String string) {
        if (!this.isActive()) {
            return;
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.unregisterService(string);
        }
    }

    public void registerConnection(long l) {
        ObjectName objectName;
        if (!this.isActive()) {
            return;
        }
        try {
            ConnectionMonitor connectionMonitor = new ConnectionMonitor(l);
            objectName = MQObjectName.createConnectionMonitor(Long.toString(l));
            this.agentRegisterMBean(connectionMonitor, objectName);
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2139", "Connection Monitor"), exception);
        }
        try {
            ConnectionConfig connectionConfig = new ConnectionConfig(l);
            objectName = MQObjectName.createConnectionConfig(Long.toString(l));
            this.agentRegisterMBean(connectionConfig, objectName);
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2139", "Connection Config"), exception);
        }
    }

    public void unregisterConnection(long l) {
        ObjectName objectName;
        if (!this.isActive()) {
            return;
        }
        try {
            objectName = MQObjectName.createConnectionMonitor(Long.toString(l));
            this.agentUnregisterMBean(objectName);
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2140", "Connection Monitor"), exception);
        }
        try {
            objectName = MQObjectName.createConnectionConfig(Long.toString(l));
            this.agentUnregisterMBean(objectName);
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2140", "Connection Config"), exception);
        }
    }

    private void init() {
        this.logger = Globals.getLogger();
        this.rb = Globals.getBrokerResources();
        if (!this.jmxSupportEnabled()) {
            this.logger.log(16, "B2141");
            return;
        }
        try {
            Class<?> clazz = Class.forName("javax.management.MBeanServer");
        }
        catch (Exception exception) {
            this.logger.log(16, "B2142");
            return;
        }
        try {
            if (this.platformMBeanServerAvailable()) {
                if (this.usePlatformMBeanServer()) {
                    this.mbs = this.getPlatformMBeanServer();
                    this.logger.log(8, "B1239");
                } else {
                    this.mbs = this.createMBeanServer();
                    this.logger.log(8, "B1240");
                }
            } else {
                this.mbs = this.createMBeanServer();
                this.logger.log(8, "B1240");
            }
            this.startRMIRegistry();
            this.csm = new ConnectorServerManager(this);
            this.csm.initConfiguredConnectorServers();
        }
        catch (Exception exception) {
            this.logger.log(16, "B2145", exception);
            return;
        }
        Globals.getClusterManager().addEventListener(this.cl);
        this.initJesmf();
        this.active = true;
    }

    private void initJesmf() {
        JesmfManager jesmfManager;
        Class<?> clazz;
        try {
            clazz = Class.forName("com.sun.mfwk.instrum.me.settings.CMM_MQDestinationQueueSettingInstrum");
        }
        catch (Exception exception) {
            this.logger.log(8, "JESMF classes not present - JESMF support will not be enabled.");
            return;
        }
        clazz = null;
        try {
            clazz = Class.forName("com.sun.messaging.jmq.jmsserver.management.jesmf.JesmfManagerImpl");
        }
        catch (Throwable throwable) {
            this.logger.log(8, "JESMF Manager class not present - JESMF support will not be enabled.");
            return;
        }
        try {
            jesmfManager = (JesmfManager)clazz.newInstance();
            jesmfManager.initialize(this);
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Failed to instantiate JESMF Manager class - JESMF support will not be enabled.");
            return;
        }
        if (jesmfManager.isActive()) {
            this.jesmfMgr = jesmfManager;
        }
    }

    private MBeanServer getPlatformMBeanServer() throws BrokerException {
        MBeanServer mBeanServer = null;
        try {
            Class<?> clazz = Class.forName("java.lang.management.ManagementFactory");
            Method method = clazz.getMethod("getPlatformMBeanServer", null);
            mBeanServer = (MBeanServer)method.invoke((Object)"getPlatformMBeanServer", null);
        }
        catch (Exception exception) {
            throw new BrokerException(this.rb.getString("B2149", exception.toString()));
        }
        return mBeanServer;
    }

    private void startRMIRegistry() throws BrokerException {
        Object object;
        Object var1_1 = null;
        Registry registry = null;
        boolean bl = false;
        if (!this.startRmiRegistry()) {
            return;
        }
        int n = this.getRmiRegistryPort();
        String string = Globals.getJMXHostname();
        try {
            registry = string != null && !string.equals("*") ? LocateRegistry.getRegistry(string, n) : LocateRegistry.getRegistry(n);
            object = registry.list();
            bl = true;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (bl) {
            throw new BrokerException(this.rb.getString("B2148", Integer.toString(n)));
        }
        try {
            if (string != null && !string.equals("*")) {
                object = new MQRMIServerSocketFactory(string, 0, false);
                registry = LocateRegistry.createRegistry(n, null, (RMIServerSocketFactory)object);
            } else {
                registry = LocateRegistry.createRegistry(n);
            }
            object = registry.list();
            this.logger.log(8, this.rb.getString("B1241", Integer.toString(n)));
        }
        catch (RemoteException remoteException) {
            throw new BrokerException(this.rb.getString("B2147", Integer.toString(n), remoteException.toString()));
        }
    }

    public void loadMBeans() {
        try {
            this.loadAllMBeans();
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2150", exception.toString()));
        }
    }

    private void loadAllMBeans() throws MalformedObjectNameException, ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        List list;
        Object object;
        MQMBeanReadOnly mQMBeanReadOnly;
        Object object22;
        Object object3;
        for (int i = 0; i < this.oneOnlyMBeans.length; ++i) {
            ObjectName objectName = new ObjectName(this.oneOnlyMBeans[i][1]);
            object3 = this.mbeansPkgName + "." + this.oneOnlyMBeans[i][0];
            object22 = null;
            try {
                object22 = Class.forName((String)object3).newInstance();
                this.agentRegisterMBean(object22, objectName);
                continue;
            }
            catch (Exception exception) {
                if (object22 != null && object22 instanceof MQMBeanReadOnly) {
                    mQMBeanReadOnly = (MQMBeanReadOnly)object22;
                    object = mQMBeanReadOnly.getMBeanName();
                } else {
                    object = objectName.toString();
                }
                this.logger.log(16, this.rb.getString("B2139", object), exception);
            }
        }
        this.bkrMon = new BrokerMonitor();
        ObjectName objectName = new ObjectName("com.sun.messaging.jms.server:type=Broker,subtype=Monitor");
        this.agentRegisterMBean(this.bkrMon, objectName);
        this.svcMgrMon = new ServiceManagerMonitor();
        objectName = new ObjectName("com.sun.messaging.jms.server:type=ServiceManager,subtype=Monitor");
        this.agentRegisterMBean(this.svcMgrMon, objectName);
        this.dstMgrMon = new DestinationManagerMonitor();
        objectName = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Monitor");
        this.agentRegisterMBean(this.dstMgrMon, objectName);
        this.cxnMgrMon = new ConnectionManagerMonitor();
        objectName = new ObjectName("com.sun.messaging.jms.server:type=ConnectionManager,subtype=Monitor");
        this.agentRegisterMBean(this.cxnMgrMon, objectName);
        this.conMgrMon = new ConsumerManagerMonitor();
        objectName = new ObjectName("com.sun.messaging.jms.server:type=ConsumerManager,subtype=Monitor");
        this.agentRegisterMBean(this.conMgrMon, objectName);
        this.prdMgrMon = new ProducerManagerMonitor();
        objectName = new ObjectName("com.sun.messaging.jms.server:type=ProducerManager,subtype=Monitor");
        this.agentRegisterMBean(this.prdMgrMon, objectName);
        this.txnMgrMon = new TransactionManagerMonitor();
        objectName = new ObjectName("com.sun.messaging.jms.server:type=TransactionManager,subtype=Monitor");
        this.agentRegisterMBean(this.txnMgrMon, objectName);
        this.clsMon = new ClusterMonitor();
        objectName = new ObjectName("com.sun.messaging.jms.server:type=Cluster,subtype=Monitor");
        this.agentRegisterMBean(this.clsMon, objectName);
        this.logMon = new LogMonitor();
        objectName = new ObjectName("com.sun.messaging.jms.server:type=Log,subtype=Monitor");
        this.agentRegisterMBean(this.logMon, objectName);
        if (this.msgMBeansEnabled()) {
            this.msgMgrMon = new MessageManagerMonitor();
            objectName = new ObjectName(this.MESSAGE_MANAGER_MONITOR_MBEAN_NAME);
            this.agentRegisterMBean(this.msgMgrMon, objectName);
            this.msgMgrCon = new MessageManagerConfig();
            objectName = new ObjectName(this.MESSAGE_MANAGER_CONFIG_MBEAN_NAME);
            this.agentRegisterMBean(this.msgMgrCon, objectName);
        }
        if ((list = DestinationUtil.getVisibleDestinations()).size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                object3 = (Destination)list.get(i);
                this.registerDestination((Destination)object3);
            }
        }
        List list2 = ServiceUtil.getVisibleServiceNames();
        for (Object object22 : list2) {
            this.registerService((String)object22);
        }
        if (this.mletEnabled()) {
            Object object4;
            try {
                object22 = new ObjectName(this.MQMLET_MBEAN_NAME);
                this.mqMLet = new MLet();
                this.agentRegisterMBean(this.mqMLet, (ObjectName)object22);
                this.logger.log(8, "MLET: Registering MLet MBean");
            }
            catch (Exception exception) {
                object4 = "MQMLet";
                this.logger.log(16, this.rb.getString("B2139", object4), exception);
            }
            if (this.mqMLet != null && (object22 = this.getMLetFileURL()) != null && !((String)object22).equals("")) {
                try {
                    this.logger.log(8, "MLET: Loading MBeans from MLet file: " + (String)object22);
                    object4 = this.mqMLet.getMBeansFromURL((String)object22);
                    if (object4 != null) {
                        object = object4.iterator();
                        while (object.hasNext()) {
                            Serializable serializable;
                            mQMBeanReadOnly = object.next();
                            if (mQMBeanReadOnly instanceof ObjectInstance) {
                                serializable = (ObjectInstance)((Object)mQMBeanReadOnly);
                                this.logger.log(8, "MLET: Loaded MBean [objectname=" + ((ObjectInstance)serializable).getObjectName().toString() + ", class=" + ((ObjectInstance)serializable).getClassName() + "]");
                                continue;
                            }
                            if (mQMBeanReadOnly instanceof Throwable) {
                                serializable = (Throwable)((Object)mQMBeanReadOnly);
                                this.logger.log(16, "MLET: Failed to load MBean: " + serializable);
                                continue;
                            }
                            this.logger.log(16, "MLET: Unknown object type returned by MLet MBean creation: " + mQMBeanReadOnly);
                        }
                    }
                }
                catch (Exception exception) {
                    object = "MQMLet";
                    this.logger.log(16, "Exception caught while loading MBeans via MQMLet", exception);
                }
            }
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.registerPortmapper();
        }
    }

    public void unloadMBeans() {
        if (!this.isActive()) {
            return;
        }
        List list = ServiceUtil.getVisibleServiceNames();
        for (String string : list) {
            this.unregisterService(string);
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.unregisterPortmapper();
        }
        try {
            this.agentUnregisterAllMBeans();
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2151", exception.toString()));
        }
    }

    public void notifyQuiesceStart() {
        if (this.bkrMon != null) {
            this.bkrMon.notifyQuiesceStart();
        }
    }

    public void notifyQuiesceComplete() {
        if (this.bkrMon != null) {
            this.bkrMon.notifyQuiesceComplete();
        }
    }

    public void notifyShutdownStart() {
        if (this.bkrMon != null) {
            this.bkrMon.notifyShutdownStart();
        }
    }

    public void notifyTakeoverStart(String string) {
        if (this.bkrMon != null) {
            this.bkrMon.notifyTakeoverStart(string);
        }
        if (this.clsMon != null) {
            this.clsMon.notifyTakeoverStart(string);
        }
    }

    public void notifyTakeoverComplete(String string) {
        if (this.bkrMon != null) {
            this.bkrMon.notifyTakeoverComplete(string);
        }
        if (this.clsMon != null) {
            this.clsMon.notifyTakeoverComplete(string);
        }
    }

    public void notifyTakeoverFail(String string) {
        if (this.bkrMon != null) {
            this.bkrMon.notifyTakeoverFail(string);
        }
        if (this.clsMon != null) {
            this.clsMon.notifyTakeoverFail(string);
        }
    }

    public void notifyClusterBrokerDown(String string) {
        if (this.clsMon != null) {
            this.clsMon.notifyClusterBrokerDown(string);
        }
    }

    public void notifyClusterBrokerJoin(String string) {
        if (this.clsMon != null) {
            this.clsMon.notifyClusterBrokerJoin(string);
        }
        if (this.bkrMon != null) {
            this.bkrMon.notifyClusterBrokerJoin(string);
        }
    }

    public void notifyServicePause(String string) {
        if (string == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.service.pause"));
            this.logger.log(16, "B2155");
            return;
        }
        if (this.svcMgrMon != null) {
            this.svcMgrMon.notifyServicePause(string);
        }
        ObjectName objectName = null;
        try {
            objectName = MQObjectName.createServiceMonitor(string);
            ServiceMonitor serviceMonitor = (ServiceMonitor)this.getMBean(objectName);
            if (serviceMonitor != null) {
                serviceMonitor.notifyServicePause();
            }
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2152", "mq.service.pause", objectName.toString()), exception);
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.serviceStateChanged(string);
        }
    }

    public void notifyServiceResume(String string) {
        if (string == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.service.resume"));
            this.logger.log(16, "B2155");
            return;
        }
        if (this.svcMgrMon != null) {
            this.svcMgrMon.notifyServiceResume(string);
        }
        ObjectName objectName = null;
        try {
            objectName = MQObjectName.createServiceMonitor(string);
            ServiceMonitor serviceMonitor = (ServiceMonitor)this.getMBean(objectName);
            if (serviceMonitor != null) {
                serviceMonitor.notifyServiceResume();
            }
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2152", "mq.service.resume", objectName.toString()), exception);
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.serviceStateChanged(string);
        }
    }

    public void notifyConnectionOpen(long l) {
        String string;
        if (this.cxnMgrMon != null) {
            this.cxnMgrMon.notifyConnectionOpen(l);
        }
        if ((string = ConnectionUtil.getServiceOfConnection(l)) == null) {
            this.logger.log(16, this.rb.getString("B2154", "mq.connection.open", "Service Monitor"));
            this.logger.log(16, this.rb.getString("B2156", Long.toString(l)));
            return;
        }
        ObjectName objectName = null;
        try {
            objectName = MQObjectName.createServiceMonitor(string);
            ServiceMonitor serviceMonitor = (ServiceMonitor)this.getMBean(objectName);
            if (serviceMonitor != null) {
                serviceMonitor.notifyConnectionOpen(l);
            }
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2152", "mq.connection.open", objectName.toString()), exception);
        }
    }

    public void notifyConnectionClose(long l) {
        String string;
        if (this.cxnMgrMon != null) {
            this.cxnMgrMon.notifyConnectionClose(l);
        }
        if ((string = ConnectionUtil.getServiceOfConnection(l)) == null) {
            this.logger.log(16, this.rb.getString("B2154", "mq.connection.close", "Service Monitor"));
            this.logger.log(16, this.rb.getString("B2156", Long.toString(l)));
            return;
        }
        ObjectName objectName = null;
        try {
            objectName = MQObjectName.createServiceMonitor(string);
            ServiceMonitor serviceMonitor = (ServiceMonitor)this.getMBean(objectName);
            if (serviceMonitor != null) {
                serviceMonitor.notifyConnectionClose(l);
            }
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2152", "mq.connection.close", objectName.toString()), exception);
        }
    }

    public void notifyConnectionReject(String string, String string2, String string3) {
        if (string == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.connection.reject"));
            this.logger.log(16, "B2155");
            return;
        }
        if (this.cxnMgrMon != null) {
            this.cxnMgrMon.notifyConnectionReject(string, string2, string3);
        }
        ObjectName objectName = null;
        try {
            objectName = MQObjectName.createServiceMonitor(string);
            ServiceMonitor serviceMonitor = (ServiceMonitor)this.getMBean(objectName);
            if (serviceMonitor != null) {
                serviceMonitor.notifyConnectionReject(string, string2, string3);
            }
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2152", "mq.connection.reject", objectName.toString()), exception);
        }
    }

    public void notifyDestinationAttrUpdated(Destination destination, int n, Object object, Object object2) {
        if (destination == null || !DestinationUtil.isVisibleDestination(destination)) {
            return;
        }
        ObjectName objectName = null;
        try {
            objectName = DestinationUtil.getConfigObjectName(destination);
            DestinationConfig destinationConfig = (DestinationConfig)this.getMBean(objectName);
            if (destinationConfig != null) {
                Object object3 = DestinationUtil.convertAttrValueInternaltoExternal(n, object);
                Object object4 = DestinationUtil.convertAttrValueInternaltoExternal(n, object2);
                destinationConfig.notifyDestinationAttrUpdated(n, object3, object4);
            }
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2152", "jmx.attribute.change", objectName.toString()), exception);
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.destinationAttrUpdated(destination, n, object, object2);
        }
    }

    public void notifyServiceAttrUpdated(String string, String string2, Object object, Object object2) {
        if (this.jesmfMgr != null) {
            this.jesmfMgr.serviceAttrUpdated(string, string2, object, object2);
        }
    }

    public void notifyDestinationCompact(Destination destination) {
        if (destination == null || !DestinationUtil.isVisibleDestination(destination)) {
            return;
        }
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationCompact(destination);
        }
        ObjectName objectName = null;
        try {
            objectName = DestinationUtil.getMonitorObjectName(destination);
            DestinationMonitor destinationMonitor = (DestinationMonitor)this.getMBean(objectName);
            if (destinationMonitor != null) {
                destinationMonitor.notifyDestinationCompact();
            }
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2152", "mq.destination.compact", objectName.toString()), exception);
        }
    }

    public void notifyDestinationCreate(Destination destination) {
        if (destination == null || !DestinationUtil.isVisibleDestination(destination)) {
            return;
        }
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationCreate(destination);
        }
    }

    public void notifyDestinationDestroy(Destination destination) {
        if (destination == null || !DestinationUtil.isVisibleDestination(destination)) {
            return;
        }
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationDestroy(destination);
        }
    }

    public void notifyDestinationPause(Destination destination, int n) {
        if (destination == null || !DestinationUtil.isVisibleDestination(destination)) {
            return;
        }
        String string = DestinationUtil.toExternalPauseType(n);
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationPause(destination, string);
        }
        ObjectName objectName = null;
        try {
            objectName = DestinationUtil.getMonitorObjectName(destination);
            DestinationMonitor destinationMonitor = (DestinationMonitor)this.getMBean(objectName);
            if (destinationMonitor != null) {
                destinationMonitor.notifyDestinationPause(string);
            }
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2152", "mq.destination.pause", objectName.toString()), exception);
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.destinationStateChanged(destination);
        }
    }

    public void notifyDestinationPurge(Destination destination) {
        if (destination == null || !DestinationUtil.isVisibleDestination(destination)) {
            return;
        }
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationPurge(destination);
        }
        ObjectName objectName = null;
        try {
            objectName = DestinationUtil.getMonitorObjectName(destination);
            DestinationMonitor destinationMonitor = (DestinationMonitor)this.getMBean(objectName);
            if (destinationMonitor != null) {
                destinationMonitor.notifyDestinationPurge();
            }
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2152", "mq.destination.purge", objectName.toString()), exception);
        }
    }

    public void notifyDestinationResume(Destination destination) {
        if (destination == null || !DestinationUtil.isVisibleDestination(destination)) {
            return;
        }
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationResume(destination);
        }
        ObjectName objectName = null;
        try {
            objectName = DestinationUtil.getMonitorObjectName(destination);
            DestinationMonitor destinationMonitor = (DestinationMonitor)this.getMBean(objectName);
            if (destinationMonitor != null) {
                destinationMonitor.notifyDestinationResume();
            }
        }
        catch (Exception exception) {
            this.logger.log(16, this.rb.getString("B2152", "mq.destination.resume", objectName.toString()), exception);
        }
        if (this.jesmfMgr != null) {
            this.jesmfMgr.destinationStateChanged(destination);
        }
    }

    public void notifyTransactionCommit(TransactionUID transactionUID) {
        if (transactionUID == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.transaction.commit"));
            this.logger.log(16, "B2159");
            return;
        }
        long l = transactionUID.longValue();
        if (this.txnMgrMon != null) {
            this.txnMgrMon.notifyTransactionCommit(l);
        }
    }

    public void notifyTransactionPrepare(TransactionUID transactionUID) {
        if (transactionUID == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.transaction.prepare"));
            this.logger.log(16, "B2159");
            return;
        }
        long l = transactionUID.longValue();
        if (this.txnMgrMon != null) {
            this.txnMgrMon.notifyTransactionPrepare(l);
        }
    }

    public void notifyTransactionRollback(TransactionUID transactionUID) {
        if (transactionUID == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.transaction.rollback"));
            this.logger.log(16, "B2159");
            return;
        }
        long l = transactionUID.longValue();
        if (this.txnMgrMon != null) {
            this.txnMgrMon.notifyTransactionRollback(l);
        }
    }

    public void notifyLogMessage(int n, String string) {
        if (this.logMon != null) {
            String string2 = Logger.levelIntToStr(n);
            try {
                this.logMon.notifyLogMessage(string2, string);
            }
            catch (Exception exception) {
                this.logger.log(16, this.rb.getString("B2152", "mq.log.level." + string2, "Log Monitor"), exception);
            }
        }
    }

    public void notifyResourceStateChange(String string, String string2, MemoryUsage memoryUsage) {
        if (this.bkrMon != null) {
            this.bkrMon.notifyResourceStateChange(string, string2, memoryUsage);
        }
    }

    public void portMapperPortUpdated(Integer n, Integer n2) {
        if (this.jesmfMgr != null) {
            this.jesmfMgr.portMapperPortUpdated(n, n2);
        }
    }

    public void resetMetrics() {
        if (this.cxnMgrMon != null) {
            this.cxnMgrMon.resetMetrics();
        }
        if (this.txnMgrMon != null) {
            this.txnMgrMon.resetMetrics();
        }
        List list = ServiceUtil.getVisibleServiceNames();
        for (String string : list) {
            ServiceMonitor serviceMonitor = this.getServiceMonitorMBean(string);
            if (serviceMonitor == null) continue;
            serviceMonitor.resetMetrics();
        }
    }

    public BrokerConfig getBrokerConfigMBean() {
        BrokerConfig brokerConfig = null;
        Exception exception = null;
        try {
            ObjectName objectName = new ObjectName("com.sun.messaging.jms.server:type=Broker,subtype=Config");
            brokerConfig = (BrokerConfig)this.getMBean(objectName);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (brokerConfig == null && DEBUG) {
            this.logger.log(4, "Exception caught when obtaining handle to BrokerConfig MBean: " + (exception == null ? "" : exception.toString()));
        }
        return brokerConfig;
    }

    public BrokerMonitor getBrokerMonitorMBean() {
        return this.bkrMon;
    }

    public ServiceConfig getServiceConfigMBean(String string) {
        ServiceConfig serviceConfig = null;
        Exception exception = null;
        try {
            ObjectName objectName = MQObjectName.createServiceConfig(string);
            serviceConfig = (ServiceConfig)this.getMBean(objectName);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (serviceConfig == null && DEBUG) {
            this.logger.log(4, "Exception caught when obtaining handle to ServiceConfig MBean: " + (exception == null ? "" : exception.toString()));
        }
        return serviceConfig;
    }

    public ServiceMonitor getServiceMonitorMBean(String string) {
        ServiceMonitor serviceMonitor = null;
        Exception exception = null;
        try {
            ObjectName objectName = MQObjectName.createServiceMonitor(string);
            serviceMonitor = (ServiceMonitor)this.getMBean(objectName);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (serviceMonitor == null && DEBUG) {
            this.logger.log(4, "Exception caught when obtaining handle to ServiceMonitor MBean: " + (exception == null ? "" : exception.toString()));
        }
        return serviceMonitor;
    }

    public DestinationConfig getDestinationConfigMBean(String string, String string2) {
        DestinationConfig destinationConfig = null;
        Exception exception = null;
        try {
            ObjectName objectName = MQObjectName.createDestinationConfig(string2, string);
            destinationConfig = (DestinationConfig)this.getMBean(objectName);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (destinationConfig == null && DEBUG) {
            this.logger.log(4, "Exception caught when obtaining handle to DestinationConfig MBean: " + (exception == null ? "" : exception.toString()));
        }
        return destinationConfig;
    }

    public DestinationMonitor getDestinationMonitorMBean(String string, String string2) {
        DestinationMonitor destinationMonitor = null;
        Exception exception = null;
        try {
            ObjectName objectName = MQObjectName.createDestinationMonitor(string2, string);
            destinationMonitor = (DestinationMonitor)this.getMBean(objectName);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (destinationMonitor == null && DEBUG) {
            this.logger.log(4, "Exception caught when obtaining handle to DestinationMonitor MBean: " + (exception == null ? "" : exception.toString()));
        }
        return destinationMonitor;
    }

    public String getDefaultJMXUrlPathBase() {
        MQAddress mQAddress = Globals.getMQAddress();
        String string = null;
        if (mQAddress == null) {
            return null;
        }
        String string2 = mQAddress.getHostName();
        String string3 = Globals.getJMXHostname();
        if (string3 == null) {
            string3 = string2;
        }
        int n = mQAddress.getPort();
        int n2 = this.getRmiRegistryPort();
        string = "/jndi/rmi://" + string3 + ":" + Integer.toString(n2) + "/" + string2 + "/" + Integer.toString(n) + "/";
        return string;
    }

    private MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer();
    }

    private boolean platformMBeanServerAvailable() {
        try {
            Class<?> clazz = Class.forName("java.lang.management.ManagementFactory");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean jmxSupportEnabled() {
        return this.config.getBooleanProperty(ENABLED, true);
    }

    private boolean usePlatformMBeanServer() {
        return this.config.getBooleanProperty(USE_PLATFORM_MBEANSERVER);
    }

    private void agentRegisterMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.mbs == null) {
            return;
        }
        if (!this.mbs.isRegistered(objectName)) {
            this.mbs.registerMBean(object, objectName);
            if (DEBUG) {
                this.logger.log(4, "Registered MBean: " + objectName.toString());
            }
            this.addMBean(object, objectName);
        }
    }

    private void agentUnregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.mbs == null) {
            return;
        }
        if (this.mbs.isRegistered(objectName)) {
            this.mbs.unregisterMBean(objectName);
            if (DEBUG) {
                this.logger.log(4, "Unregistered MBean: " + objectName.toString());
            }
            this.removeMBean(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentUnregisterAllMBeans() throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.mbs == null) {
            return;
        }
        Map map = this.mbeans;
        synchronized (map) {
            Set set = this.mbeans.keySet();
            ObjectName[] objectNameArray = set.toArray(new ObjectName[0]);
            for (int i = 0; i < objectNameArray.length; ++i) {
                this.agentUnregisterMBean(objectNameArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMBean(Object object, ObjectName objectName) {
        Map map = this.mbeans;
        synchronized (map) {
            this.mbeans.put(objectName, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMBean(ObjectName objectName) {
        Map map = this.mbeans;
        synchronized (map) {
            this.mbeans.remove(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMBean(ObjectName objectName) {
        Object var2_2 = null;
        Map map = this.mbeans;
        synchronized (map) {
            var2_2 = this.mbeans.get(objectName);
        }
        return var2_2;
    }

    class ClusterStateListener
    implements ClusterListener {
        ClusterStateListener() {
        }

        public void clusterPropertyChanged(String string, String string2) {
        }

        public void brokerAdded(ClusteredBroker clusteredBroker, UID uID) {
        }

        public void brokerRemoved(ClusteredBroker clusteredBroker, UID uID) {
        }

        public void masterBrokerChanged(ClusteredBroker clusteredBroker, ClusteredBroker clusteredBroker2) {
        }

        public void brokerStatusChanged(String string, int n, int n2, UID uID, Object object) {
            if (BrokerStatus.getBrokerIsUp(n2) && BrokerStatus.getBrokerIsDown(n)) {
                Agent.this.notifyClusterBrokerJoin(string);
            }
            if (BrokerStatus.getBrokerIsDown(n2) && BrokerStatus.getBrokerIsUp(n)) {
                Agent.this.notifyClusterBrokerDown(string);
            }
        }

        public void brokerStateChanged(String string, BrokerState brokerState, BrokerState brokerState2) {
            String string2;
            if (!Globals.getHAEnabled()) {
                return;
            }
            String string3 = Globals.getBrokerID();
            if ((brokerState2 == BrokerState.FAILOVER_PENDING || brokerState2 == BrokerState.FAILOVER_STARTED) && brokerState != BrokerState.FAILOVER_PENDING && brokerState != BrokerState.FAILOVER_STARTED) {
                string2 = this.getTakeoverBrokerID(string);
                if (string2 == null || !string2.equals(string3)) {
                    return;
                }
                Agent.this.notifyTakeoverStart(string);
            }
            if (brokerState2 == BrokerState.FAILOVER_COMPLETE && brokerState != BrokerState.FAILOVER_COMPLETE) {
                string2 = this.getTakeoverBrokerID(string);
                if (string2 == null || !string2.equals(string3)) {
                    return;
                }
                Agent.this.notifyTakeoverComplete(string);
            }
            if (brokerState2 == BrokerState.FAILOVER_FAILED && brokerState != BrokerState.FAILOVER_FAILED) {
                string2 = this.getTakeoverBrokerID(string);
                if (string2 == null || !string2.equals(string3)) {
                    return;
                }
                Agent.this.notifyTakeoverFail(string);
            }
        }

        private String getTakeoverBrokerID(String string) {
            ClusterManager clusterManager = Globals.getClusterManager();
            if (clusterManager == null) {
                return null;
            }
            ClusteredBroker clusteredBroker = clusterManager.getBroker(string);
            if (clusteredBroker == null) {
                return null;
            }
            Hashtable hashtable = GetClusterHandler.getBrokerClusterInfo(clusteredBroker, Agent.this.logger);
            if (hashtable == null) {
                return null;
            }
            String string2 = (String)hashtable.get("TakeoverBrokerID");
            return string2;
        }

        public void brokerVersionChanged(String string, int n, int n2) {
        }

        public void brokerURLChanged(String string, MQAddress mQAddress, MQAddress mQAddress2) {
        }
    }
}

