/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AckHandler
extends PacketHandler {
    static final int ACK_BLOCK_SIZE = 40;
    private int ackProcessCnt = 0;
    private FaultInjection fi = null;
    private TransactionList translist = null;
    private final Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    public static final int ACKNOWLEDGE_REQUEST = 0;
    public static final int UNDELIVERABLE_REQUEST = 1;
    public static final int DEAD_REQUEST = 2;

    public static void checkRequestType(int n) throws BrokerException {
        if (n > 2 || n < 0) {
            throw new BrokerException("Internal Error: unknown ackType " + n);
        }
    }

    public AckHandler(TransactionList transactionList) {
        this.translist = transactionList;
        this.fi = FaultInjection.getInjection();
    }

    /*
     * Unable to fully structure code
     */
    public boolean handle(IMQConnection var1_1, Packet var2_2) throws BrokerException {
        block43: {
            block45: {
                block44: {
                    block42: {
                        var3_3 = var2_2.getMessageBodySize();
                        var4_4 = var3_3 / 40;
                        var5_5 = var3_3 % 40;
                        var6_6 = 200;
                        var7_7 = null;
                        if (AckHandler.DEBUG) {
                            this.logger.log(4, "AckHandler: processing message {0} {1}", (Object)var2_2.toString(), var1_1.getConnectionUID().toString());
                        }
                        if (var1_1.isAdminConnection()) ** GOTO lbl-1000
                        if (FaultInjection.FAULT_INJECTION) {
                            ++this.ackProcessCnt;
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.ackProcessCnt = 0;
                        }
                        if (var4_4 == 0) {
                            this.logger.log(32, "B3100", "Internal Error: Empty Ack Message " + var2_2.getSysMessageID().toString());
                            var7_7 = "Empty ack message";
                            var6_6 = 500;
                        }
                        if (var5_5 != 0) {
                            this.logger.log(32, "B3100", "Internal Error: Invalid Ack Message Size " + String.valueOf(var3_3) + " for message " + var2_2.getSysMessageID().toString());
                            var7_7 = "corrupted ack message";
                            var6_6 = 500;
                        }
                        var8_8 = null;
                        if (var2_2.getTransactionID() != 0L) {
                            try {
                                var8_8 = new TransactionUID(var2_2.getTransactionID());
                            }
                            catch (Exception var9_9) {
                                this.logger.log(32, "B3100", (Object)("Internal Error: can not create transactionID for " + var2_2), (Throwable)var9_9);
                                var6_6 = 500;
                            }
                        }
                        var9_10 = false;
                        var10_11 = null;
                        var11_12 = null;
                        var12_13 = null;
                        var13_14 = 0;
                        var14_15 = 0;
                        var15_16 = false;
                        try {
                            var10_11 = var2_2.getProperties();
                            var16_17 = var10_11 == null ? null : (Integer)var10_11.get("JMQAckType");
                            var14_15 = var16_17 == null ? 0 : var16_17.intValue();
                            var17_20 = var10_11 == null ? null : (Boolean)var10_11.get("JMQValidate");
                            var15_16 = var17_20 == null ? false : var17_20.booleanValue();
                            AckHandler.checkRequestType(var14_15);
                            if (var14_15 == 2) {
                                var11_12 = (Throwable)var10_11.get("JMQException");
                                var12_13 = (String)var10_11.get("JMQComment");
                                var18_21 = (Integer)var10_11.get("JMSXDeliveryCount");
                                var13_14 = var18_21 == null ? -1 : var18_21.intValue();
                            }
                        }
                        catch (Exception var16_18) {
                            this.logger.logStack(8, "Internal Error: bad protocol", var16_18);
                            var14_15 = 0;
                        }
                        if (!var1_1.isAdminConnection()) {
                            if (FaultInjection.FAULT_INJECTION) {
                                var16_17 = new HashMap<K, V>();
                                if (var10_11 != null) {
                                    var16_17.putAll(var10_11);
                                }
                                var16_17.put("mqAckCount", new Integer(this.ackProcessCnt));
                                var16_17.put("mqIsTransacted", var8_8 != null);
                                this.fi.checkFaultAndExit("msg.ack.1", (Map)var16_17, 2, false);
                            }
                        }
                        var16_19 = false;
                        var17_20 = null;
                        var18_21 = null;
                        var19_22 = null;
                        var20_23 = null;
                        try {
                            if (var6_6 == 200) {
                                var21_24 = new DataInputStream(var2_2.getMessageBodyStream());
                                var19_22 = new SysMessageID[var4_4];
                                var20_23 = new ConsumerUID[var4_4];
                                for (var22_26 = 0; var22_26 < var4_4; ++var22_26) {
                                    var23_29 = var21_24.readLong();
                                    var20_23[var22_26] = new ConsumerUID(var23_29);
                                    var20_23[var22_26].setConnectionUID(var1_1.getConnectionUID());
                                    var19_22[var22_26] = new SysMessageID();
                                    var19_22[var22_26].readID((DataInput)var21_24);
                                }
                                if (var15_16) {
                                    if (var14_15 == 2 || var14_15 == 1) {
                                        var6_6 = 400;
                                        var7_7 = "Can not use JMQValidate with ackType of " + var14_15;
                                    } else if (var8_8 == null) {
                                        var6_6 = 400;
                                        var7_7 = "Can not use JMQValidate with no tid ";
                                    } else if (!this.validateMessages(var8_8, var19_22, var20_23)) {
                                        var6_6 = 404;
                                        var7_7 = "Acknowledgement not processed";
                                    }
                                } else {
                                    var18_21 = var14_15 == 2 ? this.handleDeadMsgs(var19_22, var20_23, var11_12, var12_13, var13_14) : (var14_15 == 1 ? this.handleUndeliverableMsgs(var19_22, var20_23) : (var8_8 != null ? this.handleTransaction(var8_8, var19_22, var20_23) : this.handleAcks(var1_1, var19_22, var20_23)));
                                }
                            }
                        }
                        catch (Throwable var21_25) {
                            var6_6 = 500;
                            if (var21_25 instanceof BrokerException) {
                                var6_6 = ((BrokerException)var21_25).getStatusCode();
                                var16_19 = ((BrokerException)var21_25).isRemote();
                                if (var16_19 && var19_22 != null && var20_23 != null) {
                                    var17_20 = new StringBuffer();
                                    var17_20.append(((BrokerException)var21_25).getRemoteConsumerUIDs());
                                    var17_20.append(" ");
                                    var22_27 = null;
                                    var23_30 = new ArrayList<String>();
                                    for (var24_31 = 0; var24_31 < var19_22.length; ++var24_31) {
                                        var25_32 = Destination.get(var19_22[var24_31]);
                                        var26_33 = Consumer.getConsumer(var20_23[var24_31]);
                                        var27_34 = var25_32 == null ? null : var25_32.getAddress();
                                        var28_35 = ((BrokerException)var21_25).getRemoteBrokerAddress();
                                        if (var26_33 == null || var25_32 == null || var27_34 == null || var28_35 == null || !var27_34.equals(var28_35) || var23_30.contains(var22_27 = String.valueOf(var26_33.getConsumerUID().longValue()))) continue;
                                        var23_30.add(var22_27);
                                        var17_20.append(var22_27);
                                        var17_20.append(" ");
                                    }
                                }
                            }
                            var7_7 = var21_25.getMessage();
                            if (var6_6 != 500) break block42;
                            this.logger.logStack(32, "B3100", "-------------------------------------------Internal Error: Invalid Acknowledge Packet processing\n " + (var2_2.getSendAcknowledge() != false ? " notifying client\n" : " can not notify the client") + PacketUtil.dumpPacket(var2_2) + "--------------------------------------------", var21_25);
                        }
                    }
                    if (!var1_1.isAdminConnection()) {
                        if (FaultInjection.FAULT_INJECTION) {
                            var21_24 = new HashMap<K, V>();
                            if (var10_11 != null) {
                                var21_24.putAll(var10_11);
                            }
                            var21_24.put("mqAckCount", new Integer(this.ackProcessCnt));
                            var21_24.put("mqIsTransacted", (Integer)Boolean.valueOf(var8_8 != null));
                            this.fi.checkFaultAndExit("msg.ack.2", var21_24, 2, false);
                        }
                    }
                    if (!var2_2.getSendAcknowledge()) break block43;
                    var21_24 = new Packet(var1_1.useDirectBuffers());
                    var21_24.setPacketType(25);
                    var21_24.setConsumerID(var2_2.getConsumerID());
                    var22_28 = new Hashtable<String, Object>();
                    var22_28.put("JMQStatus", new Integer(var6_6));
                    if (var7_7 != null) {
                        var22_28.put("JMQReason", var7_7);
                    }
                    if (var16_19) {
                        var22_28.put("JMQRemote", true);
                        if (var17_20 != null) {
                            var22_28.put("JMQRemoteConsumerIDs", var17_20.toString());
                        }
                    }
                    (IMQIPConnection)var1_1;
                    if (IMQIPConnection.getDumpPacket()) break block44;
                    (IMQIPConnection)var1_1;
                    if (!IMQIPConnection.getDumpOutPacket()) break block45;
                }
                var22_28.put("JMQReqID", var2_2.getSysMessageID().toString());
            }
            var21_24.setProperties(var22_28);
            var1_1.sendControlMessage((Packet)var21_24);
        }
        if (!var1_1.isAdminConnection()) {
            if (FaultInjection.FAULT_INJECTION) {
                var21_24 = new HashMap<String, Integer>();
                if (var10_11 != null) {
                    var21_24.putAll(var10_11);
                }
                var21_24.put("mqAckCount", new Integer(this.ackProcessCnt));
                var21_24.put("mqIsTransacted", (Integer)Boolean.valueOf(var8_8 != null));
                this.fi.checkFaultAndExit("msg.ack.3", var21_24, 2, false);
            }
        }
        this.cleanUp((List)var18_21);
        return true;
    }

    public void cleanUp(List list) {
        if (list != null && !list.isEmpty()) {
            for (PacketReference packetReference : list) {
                Destination destination = packetReference.getDestination();
                try {
                    if (packetReference.isDead()) {
                        destination.removeDeadMessage(packetReference);
                        continue;
                    }
                    destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                }
                catch (Exception exception) {
                    this.logger.log(8, "Internal Error: unable to clean up message " + packetReference + " after ack " + "processing");
                }
            }
        }
    }

    public List handleAcks(IMQConnection iMQConnection, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException, IOException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            Object object;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                object = Consumer.getConsumer(consumerUIDArray[i]);
                if (object == null) {
                    if (!iMQConnection.isValid() || iMQConnection.isBeingDestroyed()) {
                        this.logger.log(4, "Received ack for consumer " + consumerUIDArray[i] + " on closing connection " + iMQConnection);
                        continue;
                    }
                    if (BrokerStateHandler.shutdownStarted) {
                        throw new BrokerException("B1248");
                    }
                    throw new BrokerException("Internal Error: Unable to complete processing acks: Unknown consumer " + consumerUIDArray[i]);
                }
                if (((Consumer)object).getConsumerUID().getBrokerAddress() != Globals.getClusterBroadcast().getMyAddress()) {
                    ConsumerUID consumerUID;
                    PacketReference packetReference = Destination.get(sysMessageIDArray[i]);
                    if (!packetReference.acknowledged(consumerUID = ((Consumer)object).getConsumerUID(), ((Consumer)object).getStoredConsumerUID(), !consumerUID.isDupsOK(), true)) continue;
                    linkedList.add(packetReference);
                    continue;
                }
                this.logger.log(8, Globals.getBrokerResources().getString("B3100", "local consumer does not have associated session " + object));
                throw new BrokerException("Unknown local consumer " + consumerUIDArray[i]);
            }
            object = session.ackMessage(consumerUIDArray[i], sysMessageIDArray[i]);
            if (object == null) continue;
            linkedList.add(object);
        }
        return linkedList;
    }

    public List handleTransaction(TransactionUID transactionUID, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            Object object;
            Object object2;
            try {
                Session session = Session.getSession(consumerUIDArray[i]);
                object2 = Consumer.getConsumer(consumerUIDArray[i]);
                if (object2 == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B1260", consumerUIDArray[i]));
                }
                ConsumerUID consumerUID = ((Consumer)object2).getStoredConsumerUID();
                if (session == null) {
                    SessionUID sessionUID = ((Consumer)object2).getSessionUID();
                    session = Session.getSession(sessionUID);
                }
                if (session == null) {
                    if (BrokerStateHandler.shutdownStarted) {
                        throw new BrokerException("B1248");
                    }
                    throw new BrokerException("Internal Error: Unable to complete processing transaction: Unknown consumer/session " + consumerUIDArray[i]);
                }
                boolean bl = this.translist.addAcknowledgement(transactionUID, sysMessageIDArray[i], consumerUIDArray[i], consumerUID);
                object = session.acknowledgeInTransaction(consumerUIDArray[i], sysMessageIDArray[i], transactionUID, bl);
                if (object == null || object == Globals.getMyAddress()) continue;
                this.translist.setAckBrokerAddress(transactionUID, sysMessageIDArray[i], consumerUIDArray[i], (BrokerAddress)object);
                continue;
            }
            catch (Exception exception) {
                object2 = "[" + sysMessageIDArray[i] + ", " + consumerUIDArray[i] + "]TUID=" + transactionUID;
                if (exception instanceof BrokerException && ((BrokerException)exception).getStatusCode() != 500) {
                    this.logger.log(16, Globals.getBrokerResources().getKString("B3229", object2, exception.getMessage()), exception);
                } else {
                    this.logger.log(32, Globals.getBrokerResources().getKString("B3229", object2, exception.getMessage()), exception);
                }
                int n = -1;
                JMQXid jMQXid = null;
                try {
                    object = this.translist.retrieveState(transactionUID);
                    if (object != null) {
                        n = ((TransactionState)object).getState();
                        jMQXid = ((TransactionState)object).getXid();
                    }
                    this.translist.updateState(transactionUID, 2, true);
                }
                catch (Exception exception2) {
                    Object[] objectArray = new String[]{TransactionState.toString(n), TransactionState.toString(2), transactionUID.toString(), jMQXid == null ? "null" : jMQXid.toString()};
                    this.logger.log(16, Globals.getBrokerResources().getKString("B2179", objectArray));
                }
                if (exception instanceof TransactionAckExistException && (object = Destination.get(sysMessageIDArray[i])) != null && (((PacketReference)object).isOverrided() || ((PacketReference)object).isOverriding())) {
                    ((BrokerException)exception).overrideStatusCode(410);
                    ((BrokerException)exception).setRemoteConsumerUIDs(String.valueOf(consumerUIDArray[i].longValue()));
                    ((BrokerException)exception).setRemote(true);
                }
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                throw new BrokerException("Internal Error: Unable to  complete processing acknowledgements in a tranaction: " + exception, exception);
            }
        }
        return null;
    }

    public boolean validateMessages(TransactionUID transactionUID, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        boolean bl = false;
        try {
            this.translist.getTransactionMap(transactionUID, false);
            bl = true;
        }
        catch (BrokerException brokerException) {
            // empty catch block
        }
        if (bl) {
            for (int i = 0; i < sysMessageIDArray.length; ++i) {
                Consumer consumer = Consumer.getConsumer(consumerUIDArray[i]);
                if (consumer == null) {
                    throw new BrokerException("Internal Error, unknown consumer " + consumerUIDArray[i], 400);
                }
                if (this.translist.checkAcknowledgement(transactionUID, sysMessageIDArray[i], consumer.getConsumerUID())) continue;
                return false;
            }
        } else {
            for (int i = 0; i < sysMessageIDArray.length; ++i) {
                Consumer consumer = Consumer.getConsumer(consumerUIDArray[i]);
                if (consumer == null) {
                    throw new BrokerException("Internal Error, unknown consumer " + consumerUIDArray[i], 400);
                }
                PacketReference packetReference = Destination.get(sysMessageIDArray[i]);
                if (packetReference == null) {
                    this.logger.log(4, "in validateMessages: Could not find " + sysMessageIDArray[i]);
                    continue;
                }
                if (packetReference.hasConsumerAcked(consumer.getStoredConsumerUID())) continue;
                return false;
            }
        }
        return true;
    }

    public List handleDeadMsgs(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, Throwable throwable, String string, int n) throws BrokerException {
        ArrayList<PacketReference> arrayList = new ArrayList<PacketReference>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            PacketReference packetReference;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                this.logger.log(4, "Dead message for Unknown Consumer/Session" + consumerUIDArray[i]);
                continue;
            }
            if (DEBUG) {
                this.logger.log(4, "Handling Dead Message " + consumerUIDArray[i] + ":" + sysMessageIDArray[i]);
            }
            if ((packetReference = session.handleDead(consumerUIDArray[i], sysMessageIDArray[i], throwable, string, n)) == null) continue;
            arrayList.add(packetReference);
        }
        return arrayList;
    }

    public List handleUndeliverableMsgs(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        ArrayList<PacketReference> arrayList = new ArrayList<PacketReference>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            PacketReference packetReference;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                this.logger.log(4, "Undeliverable message for Unknown Consumer/Session" + consumerUIDArray[i]);
            }
            if (DEBUG) {
                this.logger.log(4, "Handling Undeliverable Message " + consumerUIDArray[i] + ":" + sysMessageIDArray[i]);
            }
            PacketReference packetReference2 = packetReference = session == null ? null : session.handleUndeliverable(consumerUIDArray[i], sysMessageIDArray[i]);
            if (packetReference == null) continue;
            arrayList.add(packetReference);
        }
        return arrayList;
    }
}

