/*
 * Util.java
 *
 * Created on December 21, 2003, 12:30 AM
 */

package com.sun.enterprise.config.backup.appserver;
import java.io.*;
import java.util.*;
import com.sun.enterprise.config.backup.BackupRestore;
import com.sun.enterprise.config.backup.BackupRestoreImpl;
import com.sun.enterprise.config.backup.status.StatusConstants;


/**
 *
 * @author  sridatta
 */
public class Util {
    private static final String BACKUP_ENVIRONMENT_PATH =
      "/com/sun/enterprise/config/backup/appserver/BackupEnvironment.properties";
    
    /** Creates a new instance of Util */
    public Util() {
    }
    
     private static void loadProperties() throws Exception {
         try {
            InputStream i = Util.class.getResourceAsStream( BACKUP_ENVIRONMENT_PATH );
            Properties p = new Properties();
            p.load(i);
            
            if(p == null) return;

            //set here.
           // System.out.println("System Properties=" + p);
        } catch (Exception io) {
            //fail
            //io.printStackTrace();
            throw new RuntimeException("ERROR in loading properties", io);
        }
    }
     
     static BackupRestore getBackupRestore() {
         try {
           loadProperties(); 
            return new BackupRestoreImpl(StatusConstants.TYPE_OFFLINE);
        } catch(Exception e) {
           // e.printStackTrace();
            throw new RuntimeException("ERROR creating BackupRestoreImpl", e);
        }
     }
}
