/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver;

import com.rc.retroweaver.LazyException;
import com.rc.retroweaver.NameTranslator;
import com.rc.retroweaver.RetroWeaverAttribute;
import com.rc.retroweaver.Weaver;
import com.rc.retroweaver.event.WeaveListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class ClassWeaver
extends ClassAdapter
implements Opcodes {
    private boolean lazy;
    private boolean stripAttributes;
    private int target;
    private int originalClassVersion;
    private WeaveListener listener;
    private String className;
    private boolean isEnum;
    private boolean isInterface;
    private Set<String> classLiteralCalls = new HashSet<String>();
    private static final String JAVA_LANG_CLASS = "java/lang/Class";
    private static final String FOR_NAME_METHOD = "forName";
    private static final String FOR_NAME_SIGNATURE = "(Ljava/lang/String;)Ljava/lang/Class;";
    private static final String SERIAL_ID_FIELD = "serialVersionUID";
    private static final String SERIAL_ID_SIGNATURE = "J";
    private static final String JAVA_LANG_NOCLASSDEFFOUNDERROR = "java/lang/NoClassDefFoundError";
    private static final String INIT_METHOD = "<init>";
    private static final String JAVA_LANG_NOCLASSDEFFOUNDERROR_INIT_SIGNATURE = "(Ljava/lang/String;)V";
    private static final String INIT_CAUSE_METHOD = "initCause";
    private static final String INIT_CAUSE_SIGNATURE = "(Ljava/lang/Throwable;)Ljava/lang/Throwable;";
    private static final String JAVA_LANG_CLASSNOTFOUNDEXCEPTION = "java/lang/ClassNotFoundException";
    private static final String GET_MESSAGE_METHOD = "getMessage";
    private static final String GET_MESSAGE_SIGNATURE = "()Ljava/lang/String;";
    private static final String JAVA_LANG_NOSUCHMETHODERROR = "java/lang/NoSuchMethodError";
    private static final String CLASS_FIELD_DESC = "Ljava/lang/Class;";
    private static final String CLASS_METHOD = "class$";
    private static final String CLASS_SIGNATURE = "(Ljava/lang/String;)Ljava/lang/Class;";
    private static final String ITERABLE_CLASS = "java/lang/Iterable";
    private static final String ITERATOR_METHOD = "iterator";
    private static final String ITERATOR_SIGNATURE = "()Ljava/util/Iterator;";
    private static final String ITERABLE_METHODS_CLASS = "com/rc/retroweaver/runtime/IterableMethods";
    private static final String ITERABLE_METHODS_ITERATOR_SIGNATURE = "(Ljava/lang/Object;)Ljava/util/Iterator;";
    private static final String JAVA_LANG_SYSTEM = "java/lang/System";
    private static final String NANO_TIME_METHOD = "nanoTime";
    private static final String NANO_TIME_SIGNATURE = "()J";
    private static final String CURRENT_TIME_MILLIS_METHOD = "currentTimeMillis";
    private static final String CURRENT_TIME_MILLIS_TIME_SIGNATURE = "()J";
    private static final String CLASS_METHODS_CLASS = "com/rc/retroweaver/runtime/ClassMethods";
    private static final String CAST_METHOD = "cast";
    private static final String CAST_SIGNATURE = "(Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String CAST_NEW_SIGNATURE = "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String AS_SUB_CLASS_METHOD = "asSubclass";
    private static final String AS_SUB_CLASS_SIGNATURE = "(Ljava/lang/Class;)Ljava/lang/Class;";
    private static final String AS_SUB_CLASS_NEW_SIGNATURE = "(Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/Class;";
    private static final String IS_ENUM_METHOD = "isEnum";
    private static final String IS_ENUM_SIGNATURE = "()Z";
    private static final String IS_ENUM_NEW_SIGNATURE = "(Ljava/lang/Class;)Z";
    private static final String GET_ENUM_CONSTANTS_METHOD = "getEnumConstants";
    private static final String GET_ENUM_CONSTANTS_SIGNATURE = "()[Ljava/lang/Object;";
    private static final String GET_ENUM_CONSTANTS_NEW_SIGNATURE = "(Ljava/lang/Class;)[Ljava/lang/Object;";
    private static final String JAVA_LANG_STRINGBUFFER = "java/lang/StringBuffer";
    private static final String JAVA_LANG_STRINGBUILDER = "java/lang/StringBuilder";
    private static final String JAVA_LANG_STRINGBUFFER_INIT_SIGNATURE = "(Ljava/lang/CharSequence;)V";
    private static final String JAVA_LANG_STRINGBUFFER_INIT_STRING_SIGNATURE = "(Ljava/lang/String;)V";
    private static final String APPEND_METHOD = "append";
    private static final String APPEND_SIGNATURE1 = "(Ljava/lang/CharSequence;)Ljava/lang/StringBuffer;";
    private static final String APPEND_SIGNATURE2 = "(Ljava/lang/CharSequence;II)Ljava/lang/StringBuffer;";
    private static final String APPEND_SIGNATURE3 = "(Ljava/lang/String;)Ljava/lang/StringBuffer;";
    private static final String INSERT_METHOD = "insert";
    private static final String INSERT_SIGNATURE1 = "(ILjava/lang/CharSequence;)Ljava/lang/StringBuffer;";
    private static final String INSERT_SIGNATURE2 = "(ILjava/lang/CharSequence;II)Ljava/lang/StringBuffer;";
    private static final String INSERT_SIGNATURE3 = "(ILjava/lang/String;)Ljava/lang/StringBuffer;";
    private static final String TRIM_TO_SIZE = "trimToSize";
    private static final String TRIM_TO_SIZE_SIGNATURE = "()V";
    private static final String CHAR_SEQUENCE_CLASS = "java/lang/CharSequence";
    private static final String TO_STRING_METHOD = "toString";
    private static final String TO_STRING_SIGNATURE = "()Ljava/lang/String;";
    private static final String SUB_SEQUENCE_METHOD = "subSequence";
    private static final String SUB_SEQUENCE_SIGNATURE = "(II)Ljava/lang/CharSequence;";
    private static final String AUTOBOX_CLASS = "com/rc/retroweaver/runtime/Autobox";
    private static final String VALUE_OF_METHOD = "valueOf";
    private static final String JAVA_MATH_BIGDECIMAL_CLASS = "java/math/BigDecimal";
    private static final String INT_CONSTRUCTOR_SIGNATURE = "(I)V";
    private static final String LONG_CONSTRUCTOR_SIGNATURE = "(J)V";
    private static final String DOUBLE_CONSTRUCTOR_SIGNATURE = "(D)V";
    private static final String STRING_CONSTRUCTOR_SIGNATURE = "(Ljava/lang/String;)V";
    private static final String TO_STRING_LONG_SIGNATURE = "(J)Ljava/lang/String;";
    private static final String JAVA_LANG_LONG = "java/lang/Long";
    private static final String JAVA_LANG_BOOLEAN = "java/lang/Boolean";
    private static final String PARSE_BOOLEAN_METHOD = "parseBoolean";
    private static final String PARSE_BOOLEAN_SIGNATURE = "(Ljava/lang/String;)Z";
    private static final String COMPARE_TO_METHOD = "compareTo";
    private static final String COMPARE_TO_SIGNATURE = "(Ljava/lang/Boolean;)I";
    private static final String WEAVED_COMPARE_TO_SIGNATURE = "(Ljava/lang/Boolean;Ljava/lang/Boolean;)I";
    private static final String RETROWEAVER_BOOLEAN = "com/rc/retroweaver/runtime/BooleanMethods";
    private static final String JAVA_UTIL_ARRAYS = "java/util/Arrays";
    private static final String RETROWEAVER_ARRAYS = "com/rc/retroweaver/runtime/Arrays";
    private static final String JAVA_UTIL_COLLECTIONS = "java/util/Collections";
    private static final String RETROWEAVER_COLLECTIONS = "com/rc/retroweaver/runtime/Collections";
    private static final String APPENDABLE_APPEND_SIGNATURE1 = "(C)Ljava/lang/Appendable;";
    private static final String APPENDABLE_APPEND_SIGNATURE2 = "(Ljava/lang/CharSequence;II)Ljava/lang/Appendable;";
    private static final String APPENDABLE_APPEND_SIGNATURE3 = "(Ljava/lang/CharSequence;)Ljava/lang/Appendable;";
    private static Map<String, String> boxSignatures = new HashMap<String, String>();

    public ClassWeaver(ClassVisitor cv, boolean lazy, boolean stripAttributes, int target, WeaveListener listener) {
        super(cv);
        this.lazy = lazy;
        this.stripAttributes = stripAttributes;
        this.target = target;
        this.listener = listener;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.lazy && version <= this.target) {
            throw new LazyException();
        }
        if (this.listener != null) {
            this.listener.weavingPath(name);
        }
        this.className = name;
        this.isEnum = superName != null && superName.equals("java/lang/Enum");
        this.isInterface = (access & 0x200) == 512;
        this.originalClassVersion = version;
        this.cv.visit(this.target, access, name, signature, superName, interfaces);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return this.cv.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        int newAccess;
        if ((access & 0x1040) == 4160) {
            newAccess = access & 0xFFFFEFFF & 0xFFFFFFBF;
            if (name.equals(APPEND_METHOD) && (desc.equals(APPENDABLE_APPEND_SIGNATURE1) || desc.equals(APPENDABLE_APPEND_SIGNATURE2) || desc.equals(APPENDABLE_APPEND_SIGNATURE3))) {
                return null;
            }
        } else {
            newAccess = access;
        }
        MethodWeaver mv = new MethodWeaver(super.visitMethod(newAccess, name, desc, signature, exceptions));
        if (!this.isEnum || !name.equals("<clinit>")) {
            return mv;
        }
        return new EnumMethodWeaver(mv);
    }

    public void visitAttribute(Attribute attr) {
        if (attr instanceof RetroWeaverAttribute) {
            RetroWeaverAttribute ra = (RetroWeaverAttribute)attr;
            this.originalClassVersion = ra.getOriginalClassVersion();
        } else {
            this.cv.visitAttribute(attr);
        }
    }

    public void visitEnd() {
        if (this.isEnum) {
            this.cv.visitField(4122, SERIAL_ID_FIELD, SERIAL_ID_SIGNATURE, null, new Long(0L));
        }
        if (this.classLiteralCalls.size() != 0) {
            Iterator<String> i$ = this.classLiteralCalls.iterator();
            while (i$.hasNext()) {
                String fieldName = i$.next();
                FieldVisitor fv = this.visitField(4120 + (this.isInterface ? 1 : 2), fieldName, CLASS_FIELD_DESC, null, null);
                fv.visitEnd();
            }
            if (!this.isInterface) {
                String[] exceptionTable = new String[]{JAVA_LANG_NOCLASSDEFFOUNDERROR};
                MethodVisitor mv = this.cv.visitMethod(4104, CLASS_METHOD, "(Ljava/lang/String;)Ljava/lang/Class;", null, exceptionTable);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                this.generateClassCall(mv);
                mv.visitInsn(176);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
        }
        if (!this.stripAttributes) {
            RetroWeaverAttribute a = new RetroWeaverAttribute(Weaver.getBuildNumber(), this.originalClassVersion);
            this.cv.visitAttribute(a);
        }
        this.cv.visitEnd();
    }

    private void generateClassCall(MethodVisitor mv) {
        Label start1 = new Label();
        Label end1 = new Label();
        Label handler1 = new Label();
        mv.visitTryCatchBlock(start1, end1, handler1, JAVA_LANG_CLASSNOTFOUNDEXCEPTION);
        Label start2 = new Label();
        Label end2 = new Label();
        Label handler2 = new Label();
        mv.visitTryCatchBlock(start2, end2, handler2, JAVA_LANG_NOSUCHMETHODERROR);
        mv.visitLabel(start1);
        mv.visitMethodInsn(184, JAVA_LANG_CLASS, FOR_NAME_METHOD, "(Ljava/lang/String;)Ljava/lang/Class;");
        mv.visitVarInsn(58, 1);
        mv.visitLabel(end1);
        Label gotoLabel1 = new Label();
        mv.visitJumpInsn(167, gotoLabel1);
        mv.visitLabel(handler1);
        mv.visitVarInsn(58, 2);
        mv.visitTypeInsn(187, JAVA_LANG_NOCLASSDEFFOUNDERROR);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, JAVA_LANG_CLASSNOTFOUNDEXCEPTION, GET_MESSAGE_METHOD, "()Ljava/lang/String;");
        mv.visitMethodInsn(183, JAVA_LANG_NOCLASSDEFFOUNDERROR, INIT_METHOD, "(Ljava/lang/String;)V");
        mv.visitVarInsn(58, 3);
        mv.visitLabel(start2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, JAVA_LANG_NOCLASSDEFFOUNDERROR, INIT_CAUSE_METHOD, INIT_CAUSE_SIGNATURE);
        mv.visitInsn(87);
        mv.visitLabel(end2);
        Label gotoLabel2 = new Label();
        mv.visitJumpInsn(167, gotoLabel2);
        mv.visitLabel(handler2);
        mv.visitVarInsn(58, 4);
        mv.visitLabel(gotoLabel2);
        mv.visitVarInsn(25, 3);
        mv.visitInsn(191);
        mv.visitLabel(gotoLabel1);
        mv.visitVarInsn(25, 1);
    }

    static {
        boxSignatures.put(JAVA_LANG_BOOLEAN, "(Z)Ljava/lang/Boolean;");
        boxSignatures.put("java/lang/Byte", "(B)Ljava/lang/Byte;");
        boxSignatures.put("java/lang/Character", "(C)Ljava/lang/Character;");
        boxSignatures.put("java/lang/Short", "(S)Ljava/lang/Short;");
        boxSignatures.put("java/lang/Integer", "(I)Ljava/lang/Integer;");
        boxSignatures.put(JAVA_LANG_LONG, "(J)Ljava/lang/Long;");
        boxSignatures.put("java/lang/Float", "(F)Ljava/lang/Float;");
        boxSignatures.put("java/lang/Double", "(D)Ljava/lang/Double;");
    }

    class MethodWeaver
    extends MethodAdapter
    implements Opcodes {
        public MethodWeaver(MethodVisitor mv) {
            super(mv);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            this.mv.visitMaxs(maxStack, maxLocals);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String sig;
            if ((opcode == 182 || opcode == 183) && owner.equals(ClassWeaver.JAVA_LANG_CLASS)) {
                if (name.equals(ClassWeaver.CAST_METHOD) && desc.equals(ClassWeaver.CAST_SIGNATURE)) {
                    super.visitMethodInsn(184, ClassWeaver.CLASS_METHODS_CLASS, name, ClassWeaver.CAST_NEW_SIGNATURE);
                    return;
                }
                if (name.equals(ClassWeaver.AS_SUB_CLASS_METHOD) && desc.equals(ClassWeaver.AS_SUB_CLASS_SIGNATURE)) {
                    super.visitMethodInsn(184, ClassWeaver.CLASS_METHODS_CLASS, name, ClassWeaver.AS_SUB_CLASS_NEW_SIGNATURE);
                    return;
                }
                if (name.equals(ClassWeaver.IS_ENUM_METHOD) && desc.equals(ClassWeaver.IS_ENUM_SIGNATURE)) {
                    super.visitMethodInsn(184, ClassWeaver.CLASS_METHODS_CLASS, name, ClassWeaver.IS_ENUM_NEW_SIGNATURE);
                    return;
                }
                if (name.equals(ClassWeaver.GET_ENUM_CONSTANTS_METHOD) && desc.equals(ClassWeaver.GET_ENUM_CONSTANTS_SIGNATURE)) {
                    super.visitMethodInsn(184, ClassWeaver.CLASS_METHODS_CLASS, name, ClassWeaver.GET_ENUM_CONSTANTS_NEW_SIGNATURE);
                    return;
                }
            } else if (owner.equals(ClassWeaver.JAVA_MATH_BIGDECIMAL_CLASS) && name.equals(ClassWeaver.INIT_METHOD)) {
                if (desc.equals(ClassWeaver.INT_CONSTRUCTOR_SIGNATURE)) {
                    super.visitInsn(135);
                    super.visitMethodInsn(183, ClassWeaver.JAVA_MATH_BIGDECIMAL_CLASS, ClassWeaver.INIT_METHOD, ClassWeaver.DOUBLE_CONSTRUCTOR_SIGNATURE);
                    return;
                }
                if (desc.equals(ClassWeaver.LONG_CONSTRUCTOR_SIGNATURE)) {
                    super.visitMethodInsn(184, ClassWeaver.JAVA_LANG_LONG, ClassWeaver.TO_STRING_METHOD, ClassWeaver.TO_STRING_LONG_SIGNATURE);
                    super.visitMethodInsn(183, ClassWeaver.JAVA_MATH_BIGDECIMAL_CLASS, ClassWeaver.INIT_METHOD, "(Ljava/lang/String;)V");
                    return;
                }
            } else {
                if (opcode == 185 && owner.equals(ClassWeaver.ITERABLE_CLASS) && name.equals(ClassWeaver.ITERATOR_METHOD) && desc.equals(ClassWeaver.ITERATOR_SIGNATURE)) {
                    super.visitMethodInsn(184, ClassWeaver.ITERABLE_METHODS_CLASS, ClassWeaver.ITERATOR_METHOD, ClassWeaver.ITERABLE_METHODS_ITERATOR_SIGNATURE);
                    return;
                }
                if (opcode == 184 && owner.equals(ClassWeaver.JAVA_LANG_SYSTEM) && name.equals(ClassWeaver.NANO_TIME_METHOD) && desc.equals("()J")) {
                    super.visitMethodInsn(184, ClassWeaver.JAVA_LANG_SYSTEM, ClassWeaver.CURRENT_TIME_MILLIS_METHOD, "()J");
                    super.visitLdcInsn(new Long(1000000L));
                    super.visitInsn(105);
                    return;
                }
                if (owner.equals(ClassWeaver.JAVA_LANG_STRINGBUFFER) || owner.equals(ClassWeaver.JAVA_LANG_STRINGBUILDER)) {
                    if (opcode == 183 && name.equals(ClassWeaver.INIT_METHOD) && desc.equals(ClassWeaver.JAVA_LANG_STRINGBUFFER_INIT_SIGNATURE)) {
                        super.visitMethodInsn(185, ClassWeaver.CHAR_SEQUENCE_CLASS, ClassWeaver.TO_STRING_METHOD, "()Ljava/lang/String;");
                        super.visitMethodInsn(183, ClassWeaver.JAVA_LANG_STRINGBUFFER, ClassWeaver.INIT_METHOD, "(Ljava/lang/String;)V");
                        return;
                    }
                    if (opcode == 182) {
                        String d;
                        if (name.equals(ClassWeaver.TRIM_TO_SIZE) && desc.equals(ClassWeaver.TRIM_TO_SIZE_SIGNATURE)) {
                            super.visitInsn(87);
                            return;
                        }
                        if (name.equals(ClassWeaver.APPEND_METHOD)) {
                            d = desc.replaceAll("StringBuilder", "StringBuffer");
                            if (d.equals(ClassWeaver.APPEND_SIGNATURE1)) {
                                super.visitMethodInsn(185, ClassWeaver.CHAR_SEQUENCE_CLASS, ClassWeaver.TO_STRING_METHOD, "()Ljava/lang/String;");
                                super.visitMethodInsn(182, ClassWeaver.JAVA_LANG_STRINGBUFFER, ClassWeaver.APPEND_METHOD, ClassWeaver.APPEND_SIGNATURE3);
                                return;
                            }
                            if (d.equals(ClassWeaver.APPEND_SIGNATURE2)) {
                                super.visitMethodInsn(185, ClassWeaver.CHAR_SEQUENCE_CLASS, ClassWeaver.SUB_SEQUENCE_METHOD, ClassWeaver.SUB_SEQUENCE_SIGNATURE);
                                super.visitMethodInsn(185, ClassWeaver.CHAR_SEQUENCE_CLASS, ClassWeaver.TO_STRING_METHOD, "()Ljava/lang/String;");
                                super.visitMethodInsn(182, ClassWeaver.JAVA_LANG_STRINGBUFFER, ClassWeaver.APPEND_METHOD, ClassWeaver.APPEND_SIGNATURE3);
                                return;
                            }
                        } else if (name.equals(ClassWeaver.INSERT_METHOD)) {
                            d = desc.replaceAll("StringBuilder", "StringBuffer");
                            if (d.equals(ClassWeaver.INSERT_SIGNATURE1)) {
                                super.visitMethodInsn(185, ClassWeaver.CHAR_SEQUENCE_CLASS, ClassWeaver.TO_STRING_METHOD, "()Ljava/lang/String;");
                                super.visitMethodInsn(182, ClassWeaver.JAVA_LANG_STRINGBUFFER, ClassWeaver.INSERT_METHOD, ClassWeaver.INSERT_SIGNATURE3);
                                return;
                            }
                            if (d.equals(ClassWeaver.INSERT_SIGNATURE2)) {
                                super.visitMethodInsn(185, ClassWeaver.CHAR_SEQUENCE_CLASS, ClassWeaver.SUB_SEQUENCE_METHOD, ClassWeaver.SUB_SEQUENCE_SIGNATURE);
                                super.visitMethodInsn(185, ClassWeaver.CHAR_SEQUENCE_CLASS, ClassWeaver.TO_STRING_METHOD, "()Ljava/lang/String;");
                                super.visitMethodInsn(182, ClassWeaver.JAVA_LANG_STRINGBUFFER, ClassWeaver.INSERT_METHOD, ClassWeaver.INSERT_SIGNATURE3);
                                return;
                            }
                        }
                    }
                } else if (opcode == 184 && owner.equals(ClassWeaver.JAVA_UTIL_ARRAYS)) {
                    if (!ClassWeaver.this.className.equals(ClassWeaver.RETROWEAVER_ARRAYS)) {
                        super.visitMethodInsn(opcode, ClassWeaver.RETROWEAVER_ARRAYS, name, desc);
                        return;
                    }
                } else if (opcode == 184 && owner.equals(ClassWeaver.JAVA_UTIL_COLLECTIONS)) {
                    if (!ClassWeaver.this.className.equals(ClassWeaver.RETROWEAVER_COLLECTIONS)) {
                        super.visitMethodInsn(opcode, ClassWeaver.RETROWEAVER_COLLECTIONS, name, desc);
                        return;
                    }
                } else if (owner.equals(ClassWeaver.JAVA_LANG_BOOLEAN)) {
                    if (opcode == 184 && name.equals(ClassWeaver.PARSE_BOOLEAN_METHOD) && desc.equals(ClassWeaver.PARSE_BOOLEAN_SIGNATURE)) {
                        super.visitMethodInsn(opcode, ClassWeaver.RETROWEAVER_BOOLEAN, name, desc);
                        return;
                    }
                    if (opcode == 182 && name.equals(ClassWeaver.COMPARE_TO_METHOD) && desc.equals(ClassWeaver.COMPARE_TO_SIGNATURE)) {
                        super.visitMethodInsn(184, ClassWeaver.RETROWEAVER_BOOLEAN, name, ClassWeaver.WEAVED_COMPARE_TO_SIGNATURE);
                        return;
                    }
                }
            }
            if (opcode == 184 && name.equals(ClassWeaver.VALUE_OF_METHOD) && (sig = (String)boxSignatures.get(owner)) != null && sig.equals(desc)) {
                this.mv.visitMethodInsn(184, ClassWeaver.AUTOBOX_CLASS, ClassWeaver.VALUE_OF_METHOD, (String)boxSignatures.get(owner));
                return;
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                Type t = (Type)cst;
                String fieldName = this.getClassLiteralFieldName(t);
                ClassWeaver.this.classLiteralCalls.add(fieldName);
                this.mv.visitFieldInsn(178, ClassWeaver.this.className, fieldName, ClassWeaver.CLASS_FIELD_DESC);
                Label nonNullLabel = new Label();
                this.mv.visitJumpInsn(199, nonNullLabel);
                String s = t.getSort() == 10 ? t.getInternalName() : t.getDescriptor();
                s = NameTranslator.translate(s);
                this.mv.visitLdcInsn(s.replace('/', '.'));
                if (ClassWeaver.this.isInterface) {
                    ClassWeaver.this.generateClassCall(this.mv);
                } else {
                    this.mv.visitMethodInsn(184, ClassWeaver.this.className, ClassWeaver.CLASS_METHOD, "(Ljava/lang/String;)Ljava/lang/Class;");
                }
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(179, ClassWeaver.this.className, fieldName, ClassWeaver.CLASS_FIELD_DESC);
                Label endLabel = new Label();
                this.mv.visitJumpInsn(167, endLabel);
                this.mv.visitLabel(nonNullLabel);
                this.mv.visitFieldInsn(178, ClassWeaver.this.className, fieldName, ClassWeaver.CLASS_FIELD_DESC);
                this.mv.visitLabel(endLabel);
            } else {
                super.visitLdcInsn(cst);
            }
        }

        private String getClassLiteralFieldName(Type type) {
            String fieldName;
            if (type.getSort() == 9) {
                fieldName = "array" + type.getDescriptor().replace('[', '$');
                if (fieldName.charAt(fieldName.length() - 1) == ';') {
                    fieldName = fieldName.substring(0, fieldName.length() - 1);
                }
            } else {
                fieldName = ClassWeaver.CLASS_METHOD + type.getInternalName();
            }
            fieldName = fieldName.replace('/', '$');
            return fieldName;
        }
    }

    private class EnumMethodWeaver
    extends MethodAdapter
    implements Opcodes {
        public EnumMethodWeaver(MethodVisitor mv) {
            super(mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                String owner = ClassWeaver.this.className.replace('.', '/');
                String fullName = 'L' + owner + ';';
                Type t = Type.getType(fullName);
                this.mv.visitMethodInsn(184, owner, "values", "()[" + fullName);
                this.mv.visitLdcInsn(t);
                this.mv.visitMethodInsn(184, "com/rc/retroweaver/runtime/Enum_", "setEnumValues", "([Ljava/lang/Object;Ljava/lang/Class;)V");
            }
            this.mv.visitInsn(opcode);
        }
    }
}

