/*  Festalon - NSF Player
 *  Copyright (C) 2002 Ben Parnell
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "common.h"

static DECLFW(FDSWaveWrite);
static DECLFR(FDSWaveRead);
static DECLFR(FDSSRead);
static DECLFW(FDSSWrite);

uint8 FDSBIOS[8192];

void FDSSoundReset(void);
void FDSSoundStateAdd(void);
static void RenderSound(void);

/* Begin FDS sound */

typedef struct {
        int64 cycles;           // Cycles per PCM sample
        int64 count;		// Cycle counter
	int64 envcount;		// Envelope cycle counter
	uint32 b19shiftreg60;
	uint32 b24adder66;
	uint32 b24latch68;
	uint32 b17latch76;
        int32 clockcount;	// Counter to divide frequency by 8.
	uint8 b8shiftreg88;	// Modulation register.
	uint8 amplitude[2];	// Current amplitudes.
        uint8 mwave[0x20];      // Modulation waveform
        uint8 cwave[0x40];      // Game-defined waveform(carrier)
        uint8 SPSG[0xB];
} FDSSOUND;

static FDSSOUND fdso;

#define	SPSG	fdso.SPSG
#define b19shiftreg60	fdso.b19shiftreg60
#define b24adder66	fdso.b24adder66
#define b24latch68	fdso.b24latch68
#define b17latch76	fdso.b17latch76
#define b8shiftreg88	fdso.b8shiftreg88
#define clockcount	fdso.clockcount
#define amplitude	fdso.amplitude

static DECLFR(FDSSRead)
{
 switch(A&0xF)
 {
  case 0x0:return(amplitude[0]|(X.DB&0xC0));
  case 0x2:return(amplitude[1]|(X.DB&0xC0));
 }
 return(X.DB);
}

static DECLFW(FDSSWrite)
{
 RenderSound();
 A-=0x4080;
 switch(A)
 {
  case 0x0: 
  case 0x4:
	    if(!(V&0x80))
	    {
 	      // if(V&0x40) amplitude[(A&0xF)>>2]=0;
	      // else amplitude[(A&0xF)>>2]=0x3F;
	    }
	    else 
	     amplitude[(A&0xF)>>2]=V&0x3F;
	    break;
  case 0x7: b17latch76=0;SPSG[0x5]=0;break;
  case 0x8:
	   //printf("%d:$%02x\n",SPSG[0x5],V);
	   fdso.mwave[SPSG[0x5]&0x1F]=V&0x7;
           SPSG[0x5]=(SPSG[0x5]+1)&0x1F;
	   break;
 }
 //if(A>=0x7 && A!=0x8 && A<=0xF)
 //if(A==0xA || A==0x9) printf("$%04x:$%02x\n",A,V);
 SPSG[A]=V;
}

// $4080 - Fundamental wave amplitude data register 92
// $4082 - Fundamental wave frequency data register 58
// $4083 - Same as $4082($4083 is the upper 4 bits).

// $4084 - Modulation amplitude data register 78
// $4086 - Modulation frequency data register 72
// $4087 - Same as $4086($4087 is the upper 4 bits)


static void DoEnv()
{
 int x;

 for(x=0;x<2;x++)
  if(!(SPSG[x<<2]&0x80) && !(SPSG[0x3]&0x40))
  {
   static int counto[2]={0,0};

   if(counto[x]<=0)
   {
    if(SPSG[x<<2]&0x40)
    {
     if(amplitude[x]<0x3F)
      amplitude[x]++;
    }
    else
    {
     if(amplitude[x]>0)
      amplitude[x]--;
    }
    counto[x]=(SPSG[x<<2]&0x3F);
   }
   else
    counto[x]--;
  }
}

static DECLFR(FDSWaveRead)
{
 return(fdso.cwave[A&0x3f]|(X.DB&0xC0));
}

static DECLFW(FDSWaveWrite)
{
 if(SPSG[0x9]&0x80)
  fdso.cwave[A&0x3f]=V&0x3F;
}

static INLINE void ClockRise(void)
{
 if(!clockcount)
 {
  b19shiftreg60=(SPSG[0x2]|((SPSG[0x3]&0xF)<<8));
  b17latch76=(SPSG[0x6]|((SPSG[0x07]&0x3)<<8))+b17latch76;

  if(!(SPSG[0x7]&0x80))
  {
   int t=fdso.mwave[(b17latch76>>13)&0x1F]&7;
   int t2=amplitude[1];
   t2&=31;
   if(t&4)
    t=0x80-((t&3))*t2;
   else
    t=0x80+((t&3))*t2; 
   b8shiftreg88=t;
  }
  else
  { b8shiftreg88=0x80;}
 }
 else
 {
  b19shiftreg60<<=1;  
  b8shiftreg88>>=1;
 }
 b24adder66=(b24latch68+b19shiftreg60)&0x1FFFFFF;
}

static INLINE void ClockFall(void)
{
// if(!(SPSG[0x7]&0x80))
 {
  if((b8shiftreg88&1))
   b24latch68=b24adder66;
 }
 clockcount=(clockcount+1)&7;
}

static INLINE int32 FDSDoSound(void)
{
 static int divvo=0;

 divvo=(divvo+1)&1;
 if(!divvo)
 {
  ClockRise();
  ClockFall();
  fdso.envcount--;
  if(fdso.envcount<=0)
  {
   // Fix this?
   fdso.envcount+=SPSG[0xA]*2;
   DoEnv();
  }
 }

 {
  int k=amplitude[0];
  if(k>0x20) k=0x20;
  return (fdso.cwave[b24latch68>>19]*k)*4/((SPSG[0x9]&0x3)+2);
 }
}

static int32 FBC=0;

static void RenderSound(void)
{
 int32 x;

 if(!(SPSG[0x9]&0x80) && !(FSettings.disabled&0x20))
  for(x=FBC;x<timestamp;x++)
  {
   uint32 t=FDSDoSound();
   t+=t>>1;
   WaveHi[x]+=t;
  }
 FBC=timestamp;
}

void FDSSSync(int32 ts)
{
  RenderSound();
  FBC=ts;
}

static void FDS_ESI(void)
{
 SetReadHandler(0x4040,0x407f,FDSWaveRead);
 SetWriteHandler(0x4040,0x407f,FDSWaveWrite);
 SetWriteHandler(0x4080,0x408A,FDSSWrite);
 SetReadHandler(0x4090,0x4092,FDSSRead);
}

void FDSSoundReset(void)
{
 memset(&fdso,0,sizeof(fdso));
 FDS_ESI();
 GameExpSound.HiFill=RenderSound;
 GameExpSound.HiSync=FDSSSync;
 GameExpSound.RChange=FDS_ESI;
}
