/*
Copyright (C) 2000  Ralf Wiebicke

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

package tudresden.ocl.check.types;

/** 
   Abstracts an extension of the ReflectionFacade.
   Makes additional type information available,
   which cannot be obtained from the reflection api.
*/
public interface ReflectionExtender 
{
  /**
     Returns the element type of the given class attribute.
     Makes sense for container attributes only, 
     such as java.util.Collections.
     The implementer should search for additional information,
     which is not available through the reflection api.
     Returns null, if no additional information is available.
  */
  public Class getElementType(java.lang.reflect.Field f);

  /**
     Returns the key type of the given class attribute.
     Makes sense for qualified container attributes only, 
     such as java.util.Map.
     The implementer should search for additional information,
     which is not available through the reflection api.
     Returns null, if no additional information is available.
  */
  public Class getKeyType(java.lang.reflect.Field f);

}
