#!/bin/bash
# 
# waiting-for.sh
#
# Jason Kim <jason@userful.com>
# Copyright (c) 2002-2007 Userful Corporation
#
# Waiting for something finished.
#

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

MAX_WAITING_TIME=180
MIN_TIME_TO_WAIT=5
CHECKING_INTERVAL=5

if [[ -n "$1" ]]; then
    until [ -z "$1" ]; do
        case "$1" in
            --input)
                WAITING_FOR="input"
                ;;
            --hub)
                WAITING_FOR="hub"
                ;;
            -interval)
                CHECKING_INTERVAL=$2
                shift 
                ;;
            *)
                echo ""
                echo "Available options:" >> $logfile
                echo "  --input  (Waiting for input devices initialized)" >> $logfile
                echo ""
        esac
        shift
    done
fi

echo "`date +"%b %d %T"` $ProgramName: USB $WAITING_FOR, interval=$CHECKING_INTERVAL" >>  $logfile

AVAIL_HEADS=`cat /etc/X11/stations`
START_TIME=`date +%s`

if [[ "$WAITING_FOR" == "hub" ]]; then
    rm -f /tmp/usbhub-hotplug
    sleep $((AVAIL_HEADS+1))

    while [[ -e /tmp/usbhub-hotplug ]]; do
        # rmove usbhub-hotplug.  usbhub hotplug agent will create this file in background.
        rm -f /tmp/usbhub-hotplug
        sleep $CHECKING_INTERVAL
    done

elif [[ "$WAITING_FOR" == "input" ]]; then

    rm -f /tmp/input-hotplug
    sleep $CHECKING_INTERVAL

    while [[ -e /tmp/input-hotplug ]]; do
        # rmove input-hotplug file.  Input hotplug agent will create this file in background.
        rm -f /tmp/input-hotplug
        sleep $CHECKING_INTERVAL
    done
else
    # For other waitings in the future..
    :
fi
