#ifndef SCREEM_HELPER_H
#define SCREEM_HELPER_H

#include <glib-object.h>

#include "screem-page.h"

#define SCREEM_TYPE_HELPER            (screem_helper_get_type ())
#define SCREEM_HELPER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_HELPER, ScreemHelper))
#define SCREEM_HELPER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_HELPER, ScreemHelperClass))
#define SCREEM_IS_HELPER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_HELPER))


#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif

typedef struct ScreemHelperPrivate ScreemHelperPrivate;

typedef enum {
	SCREEM_HELPER_STDIN_NONE = 0,
	SCREEM_HELPER_STDIN_SELECTION,
	SCREEM_HELPER_STDIN_USER
} HelperInputMode;

typedef enum {
	SCREEM_HELPER_STDOUT_NONE = 0,
	SCREEM_HELPER_STDOUT_SELECTION,
	SCREEM_HELPER_STDOUT_INSERT
} HelperOutputMode;

typedef struct {
	GObject parent;

	ScreemHelperPrivate *priv;
} ScreemHelper;

typedef struct {
	GObjectClass parent_class;

	void (*helper_failed)( ScreemHelper *helper );
	void (*helper_error)( ScreemHelper *helper, gint status );
	
} ScreemHelperClass;


GType screem_helper_get_type( void );

ScreemHelper* screem_helper_new( const gchar *name,
				 const gchar *pathname,
				 const gchar *iconpath,
				 HelperInputMode imode,
				 HelperOutputMode omode );
ScreemHelper *screem_helper_new_from_file( const gchar *file );

gboolean screem_helper_save( ScreemHelper *helper );

void screem_helper_execute( ScreemHelper *helper, ScreemPage *page,
		ScreemWindow *window );

void screem_helper_add_to_window( ScreemHelper *helper,
				  ScreemWindow *window );
void screem_helper_remove_from_window( ScreemHelper *helper,
				       ScreemWindow *window );

gchar *screem_helper_get_uiname( ScreemHelper *helper );

#endif
