/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMimeTypeArray.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "MimeTypeArray.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSMimeTypeArrayTableEntries[] =
{
    { "length", JSMimeTypeArray::LengthAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSMimeTypeArrayTable = 
{
    2, 1, JSMimeTypeArrayTableEntries, 1
};

/* Hash table for prototype */

static const HashEntry JSMimeTypeArrayPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSMimeTypeArrayPrototypeTable = 
{
    2, 1, JSMimeTypeArrayPrototypeTableEntries, 1
};

const ClassInfo JSMimeTypeArrayPrototype::info = { "MimeTypeArrayPrototype", 0, &JSMimeTypeArrayPrototypeTable, 0 };

JSObject* JSMimeTypeArrayPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSMimeTypeArrayPrototype>(exec, "[[JSMimeTypeArray.prototype]]");
}

const ClassInfo JSMimeTypeArray::info = { "MimeTypeArray", 0, &JSMimeTypeArrayTable, 0 };

JSMimeTypeArray::JSMimeTypeArray(ExecState* exec, MimeTypeArray* impl)
    : m_impl(impl)
{
    setPrototype(JSMimeTypeArrayPrototype::self(exec));
}

JSMimeTypeArray::~JSMimeTypeArray()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSMimeTypeArray::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = Lookup::findEntry(&JSMimeTypeArrayTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSMimeTypeArray>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<MimeTypeArray*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<MimeTypeArray*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return KJS::DOMObject::getOwnPropertySlot(exec, propertyName, slot);
}

JSValue* JSMimeTypeArray::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthAttrNum: {
        MimeTypeArray* imp = static_cast<MimeTypeArray*>(impl());

        return jsNumber(imp->length());
    }
    }
    return 0;
}


JSValue* JSMimeTypeArray::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSMimeTypeArray* thisObj = static_cast<JSMimeTypeArray*>(slot.slotBase());
    return toJS(exec, static_cast<MimeTypeArray*>(thisObj->impl())->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, MimeTypeArray* obj)
{
    return KJS::cacheDOMObject<MimeTypeArray, JSMimeTypeArray>(exec, obj);
}
MimeTypeArray* toMimeTypeArray(KJS::JSValue* val)
{
    return val->isObject(&JSMimeTypeArray::info) ? static_cast<JSMimeTypeArray*>(val)->impl() : 0;
}

}
