/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment unit test for pgmdrawable.c
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* FIXME: Not complete */

#include <tests/check/common/pgmcheck.h>
#include <pgm/pgm.h>

/* Fixtures */

static PgmDrawable * drawable = NULL;

static void
test_drawable_setup (void)
{
  drawable = PGM_DRAWABLE (pgm_image_new ());
  fail_if (NULL == drawable, "drawable creation failed\n");
}

static void
test_drawable_teardown (void)
{
  ASSERT_OBJECT_REFCOUNT (drawable, "drawable", 1);
  gst_object_unref (drawable);
  drawable = NULL;
}

/* test default values */
PGM_START_TEST (test_drawable_default_values)
{
  PgmError ret;
  gfloat width, height;
  gfloat x, y, z;
  guchar r, g, b, a;
  guchar opacity;

  /* size */
  ret = pgm_drawable_get_size (drawable, &width, &height);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_size error");
  fail_if (width != 1.0f || height != 1.0f, "bad default size");

  /* position */
  ret = pgm_drawable_get_position (drawable, &x, &y, &z);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_position error");
  fail_if (x != 0.0f || y != 0.0f || z != 0.0f, "bad default position");

  /* color */
  ret = pgm_drawable_get_fg_color (drawable, &r, &g, &b, &a);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_fg_color error");
  fail_if (r != 0xFF || g != 0xFF || b != 0xFF || a != 0xFF,
           "bad default color");

  /* opacity */
  ret = pgm_drawable_get_opacity (drawable, &opacity);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_opacity error");
  fail_if (opacity != 0xFF, "bad default opacity");
}
PGM_END_TEST

/* test set/get correctness */
PGM_START_TEST (test_drawable_set_get_correctness)
{
  PgmError ret;
  gfloat width, height;
  gfloat x, y, z;
  guchar r, g, b, a;
  guchar opacity;

  /* size */
  ret = pgm_drawable_set_size (drawable, 55.55f, 66.66f);
  fail_if (ret != PGM_ERROR_OK, "drawable_set_size error");
  ret = pgm_drawable_get_size (drawable, &width, &height);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_size error");
  fail_if (width != 55.55f || height != 66.66f, "size not set");

  /* position */
  ret = pgm_drawable_set_position (drawable, 1.1f, 2.2f, 3.3f);
  fail_if (ret != PGM_ERROR_OK, "drawable_set_position error");
  ret = pgm_drawable_get_position (drawable, &x, &y, &z);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_position error");
  fail_if (x != 1.1f || y != 2.2f || z != 3.3f, "position not set");

  /* color */
  ret = pgm_drawable_set_fg_color (drawable, 0xA0, 0xA1, 0xA2, 0xA3);
  fail_if (ret != PGM_ERROR_OK, "drawable_set_fg_color error");
  ret = pgm_drawable_get_fg_color (drawable, &r, &g, &b, &a);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_fg_color error");
  fail_if (r != 0xA0 || g != 0xA1 || b != 0xA2 || a != 0xA3, "color not set");

  /* opacity */
  ret = pgm_drawable_set_opacity (drawable, 0xAB);
  fail_if (ret != PGM_ERROR_OK, "drawable_set_opacity error");
  ret = pgm_drawable_get_opacity (drawable, &opacity);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_opacity error");
  fail_if (opacity != 0xAB, "opacity not set");
}
PGM_END_TEST

PGM_START_TEST (test_drawable_set_get_parameters)
{
  gfloat width = 0, height = 0;
  gfloat x = 0, y = 0, z = 0;
  guchar r = 0, g = 0, b = 0, a = 0;
  guchar opacity;

  /* size */
  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_set_size (NULL, 55.55f, 66.66f));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_set_size (NULL, -55.55f, 66.66f));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_set_size (NULL, 55.55f, -66.66f));
  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_set_size (NULL, 55.55f, 0));
  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_set_size (NULL, 0, 66.66f));
  ASSERT_PGM_SUCCESS (pgm_drawable_set_size (drawable, 55.55f, 66.66f));

  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_size (NULL, &width, &height));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_size (drawable, NULL, &height));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_size (drawable, &width, NULL));
  ASSERT_PGM_SUCCESS (pgm_drawable_get_size (drawable, &width, &height));

  /* position */
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_set_position (NULL, 1.1f, 2.2f, 3.3f));
  ASSERT_PGM_SUCCESS (pgm_drawable_set_position (drawable, 1.1f, 2.2f, 3.3f));

  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_get_position (NULL, &x, &y, &z));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_position (drawable, NULL, &y, &z));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_position (drawable, &x, NULL, &z));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_position (drawable, &x, &y, NULL));
  ASSERT_PGM_SUCCESS (pgm_drawable_get_position (drawable, &x, &y, &z));

  /* fg_color */
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_set_fg_color (NULL, 0xA0, 0xA1, 0xA2, 0xA3));
  ASSERT_PGM_SUCCESS
    (pgm_drawable_set_fg_color (drawable, 0xA0, 0xA1, 0xA2, 0xA3));

  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_fg_color (NULL, &r, &g, &b, &a));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_fg_color (drawable, NULL, &g, &b, &a));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_fg_color (drawable, &r, NULL, &b, &a));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_fg_color (drawable, &r, &g, NULL, &a));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_fg_color (drawable, &r, &g, &b, NULL));
  ASSERT_PGM_SUCCESS (pgm_drawable_get_fg_color (drawable, &r, &g, &b, &a));

  /* bg_color */
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_set_bg_color (NULL, 0xA0, 0xA1, 0xA2, 0xA3));
  ASSERT_PGM_SUCCESS
    (pgm_drawable_set_bg_color (drawable, 0xA0, 0xA1, 0xA2, 0xA3));

  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_bg_color (NULL, &r, &g, &b, &a));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_bg_color (drawable, NULL, &g, &b, &a));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_bg_color (drawable, &r, NULL, &b, &a));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_bg_color (drawable, &r, &g, NULL, &a));
  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_drawable_get_bg_color (drawable, &r, &g, &b, NULL));
  ASSERT_PGM_SUCCESS (pgm_drawable_get_bg_color (drawable, &r, &g, &b, &a));

  /* opacity */
  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_set_opacity (NULL, 0xAB));
  ASSERT_PGM_SUCCESS (pgm_drawable_set_opacity (drawable, 0xAB));

  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_get_opacity (NULL, &opacity));
  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_get_opacity (drawable, NULL));
  ASSERT_PGM_SUCCESS (pgm_drawable_get_opacity (drawable, &opacity));
}
PGM_END_TEST

PGM_START_TEST (test_drawable_visibility)
{
  gboolean visible = TRUE;
  PgmCanvas *canvas = NULL;

  canvas = pgm_canvas_new ();
  fail_if (NULL == canvas, "canvas creation failed");

  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_is_visible (NULL, &visible));
  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_is_visible (drawable, NULL));
  ASSERT_PGM_SUCCESS (pgm_drawable_is_visible (drawable, &visible));
  /* drawables are hidden by default */
  fail_unless_equals_int (visible, FALSE);

  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_show (NULL));
  ASSERT_PGM_SUCCESS (pgm_drawable_show (drawable));
  ASSERT_PGM_SUCCESS (pgm_drawable_is_visible (drawable, &visible));
  fail_unless_equals_int (visible, TRUE);

  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_drawable_hide (NULL));
  ASSERT_PGM_SUCCESS (pgm_drawable_hide (drawable));
  ASSERT_PGM_SUCCESS (pgm_drawable_is_visible (drawable, &visible));
  fail_unless_equals_int (visible, FALSE);

  gst_object_unref (canvas);
}
PGM_END_TEST

Suite *
pgm_drawable_suite (void)
{
  Suite *s = suite_create ("PgmDrawable");
  TCase *tc_chain = tcase_create ("pgmdrawable tests");

  PGM_USE_STANDARD_FIXTURES (tc_chain);
  tcase_add_unchecked_fixture (tc_chain, test_drawable_setup,
                               test_drawable_teardown);

  suite_add_tcase (s, tc_chain);
  tcase_add_test (tc_chain, test_drawable_default_values);
  tcase_add_test (tc_chain, test_drawable_set_get_parameters);
  tcase_add_test (tc_chain, test_drawable_set_get_correctness);
  tcase_add_test (tc_chain, test_drawable_visibility);

  return s;
}

GST_CHECK_MAIN (pgm_drawable);
