/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_propread.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 17:10:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _PROPREAD_HXX_
#include <propread.hxx>
#endif
#include "rtl/tencinfo.h"
#include "rtl/textenc.h"
namespace binfilter {

// ------------------------------------------------------------------------

struct PropEntry
{
	sal_uInt32	mnId;
	sal_uInt32	mnSize;
	sal_uInt16	mnTextEnc;
	sal_uInt8*	mpBuf;

						PropEntry( sal_uInt32 nId, const sal_uInt8* pBuf, sal_uInt32 nBufSize, sal_uInt16 nTextEnc );
						PropEntry( const PropEntry& rProp );
						~PropEntry() { delete[] mpBuf; } ;

	const PropEntry&	operator=(const PropEntry& rPropEntry);
};

PropEntry::PropEntry( sal_uInt32 nId, const sal_uInt8* pBuf, sal_uInt32 nBufSize, sal_uInt16 nTextEnc ) :
	mnId		( nId ),
	mnSize		( nBufSize ),
	mnTextEnc	( nTextEnc ),
	mpBuf		( new sal_uInt8[ nBufSize ] )
{
	memcpy( (void*)mpBuf, (void*)pBuf, nBufSize );
};

PropEntry::PropEntry( const PropEntry& rProp ) :
	mnId		( rProp.mnId ),
	mnSize		( rProp.mnSize ),
	mpBuf		( new sal_uInt8[ mnSize ] ),
	mnTextEnc	( rProp.mnTextEnc )
{
	memcpy( (void*)mpBuf, (void*)rProp.mpBuf, mnSize );
};

const PropEntry& PropEntry::operator=(const PropEntry& rPropEntry)
{
	if ( this != &rPropEntry )
	{
		delete[] mpBuf;
		mnId = rPropEntry.mnId;
		mnSize = rPropEntry.mnSize;
		mnTextEnc = rPropEntry.mnTextEnc;
		mpBuf = new sal_uInt8[ mnSize ];
		memcpy( (void*)mpBuf, (void*)rPropEntry.mpBuf, mnSize );
	}
	return *this;
}

//	-----------------------------------------------------------------------

PropItem& PropItem::operator=( PropItem& rPropItem )
{
	if ( this != &rPropItem )
	{
		Seek( STREAM_SEEK_TO_BEGIN );
		delete[] SwitchBuffer();

		mnTextEnc = rPropItem.mnTextEnc;
		sal_uInt32 nPos = rPropItem.Tell();
		rPropItem.Seek( STREAM_SEEK_TO_END );
		SvMemoryStream::Write( rPropItem.GetData(), rPropItem.Tell() );
		rPropItem.Seek( nPos );
	}
	return *this;
}

//	-----------------------------------------------------------------------

struct Dict
{
	sal_uInt32	mnId;
	String		aString;

			Dict( sal_uInt32 nId, String rString ) { mnId = nId; aString = rString; };
};

//	-----------------------------------------------------------------------

Dictionary::~Dictionary()
{
	for ( void* pPtr = First(); pPtr; pPtr = Next() )
		delete (Dict*)pPtr;
}

//	-----------------------------------------------------------------------

Dictionary& Dictionary::operator=( Dictionary& rDictionary )
{
	if ( this != &rDictionary )
	{
		void* pPtr; for ( pPtr = First(); pPtr; pPtr = Next() )
			delete (Dict*)pPtr;

		for ( pPtr = rDictionary.First(); pPtr; pPtr = rDictionary.Next() )
			Insert( new Dict( ((Dict*)pPtr)->mnId, ((Dict*)pPtr)->aString ), LIST_APPEND );
	}
	return *this;
}
}
