/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: autoregisterhelper.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:59:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef AUTOREGISTER_HXX
#define AUTOREGISTER_HXX

#include <vector>
#include <rtl/ustring.hxx>

#include <cppunit/autoregister/testfunc.h>

#include "dynamicregister.hxx"
#include "getopt.hxx"

typedef std::vector<FktPtr> FunctionList;

// -----------------------------------------------------------------------------
class JobList;
class AutomaticRegisterHelper : public DynamicLibraryHelper
{
    FunctionList m_aFunctionList;
    bool m_bLoadLibraryOK;

public:
    AutomaticRegisterHelper(rtl::OUString const& _sDLLName, GetOpt & _aOptions/* , JobList * _pJobList = NULL */ );

    // FunctionList getFunctions(){return m_aFunctionList;}
    void CallAll(hTestResult _hResult) const;

    /// @return true, if the given DLLName library could load and initialised.
    bool isOkToStartTests() const {return m_bLoadLibraryOK;}
};

#endif

