/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: headerfooterhelper.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:56:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"
#include <headerfooterhelper.hxx>

#include <pagedesc.hxx>
#include <fmtcntnt.hxx>
#include <fmthdft.hxx>
#include <ndindex.hxx>



// help for lcl_SaveHeaderFooterToUndo: copy the given section (given
// rNodeIndex pointing to a start node) into the 'Autotext' section in
// the undo nodes array
// @returns NULL - if index already is in target nodes section
//          index into 
const SwStartNode* lcl_SaveSection( const SwNodeIndex& rNodeIndex, 
                                    SwNodes& rTargetNodes )
{
    DBG_ASSERT( rNodeIndex.GetNode().IsStartNode(), "expected start node" );

    // exit early, if nodes are already in target nodes array
    if( &rNodeIndex.GetNode().GetNodes() == &rTargetNodes )
        return NULL;

    // create empty section in target nodes into which to copy the result
    SwStartNode* pTargetNode = 
        rTargetNodes.MakeEmptySection( 
            rTargetNodes.GetEndOfAutotext(), 
            rNodeIndex.GetNode().GetStartNode()->GetStartNodeType() );

    // now copy...
    // from: aSourceRange - section from rNodeIndex to end of section
    // to:   aTargetIndex - the new, empty section in target nodes array
    SwNodeRange aSourceRange( rNodeIndex.GetNode(), 0,
                              *( rNodeIndex.GetNode().EndOfSectionNode() ) );
    SwNodeIndex aTargetIndex( *( pTargetNode->EndOfSectionNode() ) );
    rNodeIndex.GetNode().GetNodes()._Copy( aSourceRange, aTargetIndex, FALSE );

    return pTargetNode;
}

// examine all headers and footers from this page desc, and copy all
// relevant nodes into the given nodes array. This may be used to make
// the undo 'own' all header/footer nodes from one SwPageDesc.
void saveHeaderFooterNodes( SwPageDesc& rPageDesc,
                            SwNodes& rTargetNodes )
{
    // for both header and footer
    // - save master if active
    // - save left if active and not shares

    // master header:
    const SwFmtHeader& rMasterHead = rPageDesc.GetMaster().GetHeader();
    if( rMasterHead.IsActive() )
    {
        const SwStartNode* pNode = 
            lcl_SaveSection( * rMasterHead.GetHeaderFmt()->GetCntnt().GetCntntIdx(), rTargetNodes );
        if( pNode != NULL )
        {
            SwFrmFmt* pFormat = new SwFrmFmt( * rMasterHead.GetHeaderFmt() );
            pFormat->SetAttr( SwFmtCntnt( pNode ) );
            rPageDesc.GetMaster().SetAttr( SwFmtHeader( pFormat ) );
        }
    }

    // left header:
    if( ! rPageDesc.IsHeaderShared() )
    {
        const SwFmtHeader& rLeftHead = rPageDesc.GetLeft().GetHeader();
        if( rLeftHead.IsActive() )
        {
            const SwStartNode* pNode = 
                lcl_SaveSection( * rLeftHead.GetHeaderFmt()->GetCntnt().GetCntntIdx(), rTargetNodes );
            if( pNode != NULL )
            {
                SwFrmFmt* pFormat = new SwFrmFmt( * rLeftHead.GetHeaderFmt() );
                pFormat->SetAttr( SwFmtCntnt( pNode ) );
                rPageDesc.GetLeft().SetAttr( SwFmtHeader( pFormat ) );
            }
        }
    }

    // master footer:
    const SwFmtFooter& rMasterFoot = rPageDesc.GetMaster().GetFooter();
    if( rMasterFoot.IsActive() )
    {
        const SwStartNode* pNode = 
            lcl_SaveSection( * rMasterFoot.GetFooterFmt()->GetCntnt().GetCntntIdx(), rTargetNodes );
        if( pNode != NULL )
        {
            SwFrmFmt* pFormat = new SwFrmFmt( * rMasterFoot.GetFooterFmt() );
            pFormat->SetAttr( SwFmtCntnt( pNode ) );
            rPageDesc.GetMaster().SetAttr( SwFmtFooter( pFormat ) );
        }
    }

    // left footer:
    if( ! rPageDesc.IsFooterShared() )
    {
        const SwFmtFooter& rLeftFoot = rPageDesc.GetLeft().GetFooter();
        if( rLeftFoot.IsActive() )
        {
            const SwStartNode* pNode = 
                lcl_SaveSection( * rLeftFoot.GetFooterFmt()->GetCntnt().GetCntntIdx(), rTargetNodes );
            if( pNode != NULL )
            {
                SwFrmFmt* pFormat = new SwFrmFmt( * rLeftFoot.GetFooterFmt() );
                pFormat->SetAttr( SwFmtCntnt( pNode ) );
                rPageDesc.GetLeft().SetAttr( SwFmtFooter( pFormat ) );
            }
        }
    }
}
