/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "parsers.h"
#include "../apt.h"

#include "qhtmlstream.h"

#include <kio/slavebase.h>

namespace Parsers
{
/** Parses the output of apt-cache search */
void Search::operator() (AptProtocol* slave, const QString& tag, const QString& value)
{
  static QMap<QString, QString> results;
  static QString cur_package;
  static QString query;

  if (tag == "begin")
  {
  	query = value;
    m_result_count = 0;
  }
  else if (tag == "package")
  {
    ++m_result_count;
    cur_package = value;
  }
  else if (tag == "short_desc")
  {
  	results[cur_package] = value;
  }
  else if (tag == "end")
  {
  	// We separate results whose package name matches the query
    // and those who matches only with the description
  	QString normal, special;
    QHtmlStream sstream(&special), nstream(&normal);

    // QMap iteration sorts wrt the key < operator
    // with QStrings, it means case insensitive sort
  	QMap<QString, QString>::ConstIterator i;
    for (i = results.begin(); i != results.end(); ++i)
    {
    	const QString key = i.key();
      QHtmlStream* stream = &nstream;
      if (key == query)
      	stream = &sstream;

      (*stream)
      	<< block("tr")
        <<	block("td")
        <<		block("a") << param("href") << "apt:/show?" + key
        <<      key
        <<    close()
        <<	close() << block("td") << *i << close() << endl
        << close() << endl;
    }

    if (!special.isEmpty())
      *slave << QString("<table>") + special + QString("</table>\n<hr>\n");
    *slave << QString("<table>") + normal + QString("</table>");

    results.clear();
  }
}
}

