/* This file is part of the Keep project
   Copyright (C) 2006 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "backuplistwidget.h"

#include <qpushbutton.h>
#include <klistbox.h>
#include <qstringlist.h>
#include <kurlrequester.h>
#include <kdebug.h>

#include "backuplistviewitem.h"
#include "listviewtooltip.h"
#include "addbackupwizard.h"
#include "backupconfig.h"

BackupListWidget::BackupListWidget(QWidget *parent,char *name): BackupListView(parent,name)
{
	QToolTip::remove(m_lstBackup);
	new ListViewToolTip(m_lstBackup);
	slotReadSettings();

	connect( m_btnAdd, SIGNAL( clicked()), this, SLOT( slotAddClicked() ) );
	connect( m_btnRemove, SIGNAL( clicked()), this, SLOT( slotRemoveClicked() ) );
	connect( m_btnEdit, SIGNAL( clicked()), this, SLOT( slotEditClicked() ) );	
}

BackupListWidget::~BackupListWidget()
{
}

void BackupListWidget::slotReadSettings()
{
	m_lstBackup->clear();
	BackupConfig *backupConfig = new BackupConfig();
	QValueList<Backup> backupList = backupConfig->backupList();
	QValueList<Backup>::iterator it;
	for ( it = backupList.begin(); it != backupList.end(); ++it )
	{
		BackupListViewItem *item = new BackupListViewItem(m_lstBackup,*it);
	}
	delete backupConfig;
}

void BackupListWidget::slotSaveSettings()
{
	QValueList<Backup> backupList;
	QListViewItemIterator it( m_lstBackup );
	while ( it.current() ) {
		QListViewItem *item = it.current();
		BackupListViewItem *backupItem = static_cast<BackupListViewItem*>(item);
		backupList.append(backupItem->backup());
		++it;
	}
	BackupConfig *backupConfig = new BackupConfig();
	backupConfig->setBackupList(backupList);
	delete backupConfig;
}

void BackupListWidget::slotAddClicked()
{
	AddBackupWizard *wizard = new AddBackupWizard(this,"addBackupWizard");
	connect(wizard,SIGNAL(backupSetted(Backup) ), this, SLOT(slotAddBackup(Backup)));
	wizard->show();	
}

void BackupListWidget::slotEditClicked()
{
	QListViewItem *item = m_lstBackup->currentItem();
	if ( item )
	{
		BackupListViewItem *backupItem = static_cast<BackupListViewItem*>(item);
		AddBackupWizard *wizard = new AddBackupWizard(backupItem->backup(),this,"addBackupWizard");
		connect(wizard,SIGNAL(backupSetted(Backup) ), this, SLOT(slotUpdateBackup(Backup)));
		wizard->show();	
	}
}

void BackupListWidget::slotRemoveClicked()
{
	m_lstBackup->removeItem(m_lstBackup->currentItem());
}

void BackupListWidget::slotAddBackup(Backup backup)
{
	BackupListViewItem *item = new BackupListViewItem(m_lstBackup,backup);
}

void BackupListWidget::slotUpdateBackup(Backup backup)
{
	QListViewItem *item = m_lstBackup->currentItem();
	if ( item )
	{
		BackupListViewItem *backupItem = static_cast<BackupListViewItem*>(item);
		backupItem->setBackup(backup);
	}
}

#include "backuplistwidget.moc"
