//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;

	/// <remarks>
	///  \brief A widget containing multiple tabs
	///  It extends the Qt QTabWidget, providing extra optionally features such as close buttons when you hover
	///  over the icon in the tab, and also adds functionality such as responding to mouse wheel scroll events to switch
	///  the active tab.
	///  It is recommended to use KTabWidget instead of QTabWidget unless you have a good reason not to.
	///  See also the QTabWidget documentation.
	///   See <see cref="IKTabWidgetSignals"></see> for signals emitted by KTabWidget
	/// </remarks>		<short>    \brief A widget containing multiple tabs </short>

	[SmokeClass("KTabWidget")]
	public class KTabWidget : QTabWidget, IDisposable {
 		protected KTabWidget(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KTabWidget), this);
		}
		[Q_PROPERTY("bool", "tabReorderingEnabled")]
		public bool TabReorderingEnabled {
			get { return (bool) interceptor.Invoke("isTabReorderingEnabled", "isTabReorderingEnabled()", typeof(bool)); }
			set { interceptor.Invoke("setTabReorderingEnabled$", "setTabReorderingEnabled(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "hoverCloseButton")]
		public bool HoverCloseButton {
			get { return (bool) interceptor.Invoke("hoverCloseButton", "hoverCloseButton()", typeof(bool)); }
			set { interceptor.Invoke("setHoverCloseButton$", "setHoverCloseButton(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "hoverCloseButtonDelayed")]
		public bool HoverCloseButtonDelayed {
			get { return (bool) interceptor.Invoke("hoverCloseButtonDelayed", "hoverCloseButtonDelayed()", typeof(bool)); }
			set { interceptor.Invoke("setHoverCloseButtonDelayed$", "setHoverCloseButtonDelayed(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "tabCloseActivatePrevious")]
		public bool TabCloseActivatePrevious {
			get { return (bool) interceptor.Invoke("tabCloseActivatePrevious", "tabCloseActivatePrevious()", typeof(bool)); }
			set { interceptor.Invoke("setTabCloseActivatePrevious$", "setTabCloseActivatePrevious(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "automaticResizeTabs")]
		public bool AutomaticResizeTabs {
			get { return (bool) interceptor.Invoke("automaticResizeTabs", "automaticResizeTabs()", typeof(bool)); }
			set { interceptor.Invoke("setAutomaticResizeTabs$", "setAutomaticResizeTabs(bool)", typeof(void), typeof(bool), value); }
		}
		/// <remarks>
		///  Creates a new tab widget.
		/// <param> name="parent" The parent widgets.
		/// </param><param> name="flags" The Qt window flags @see QWidget.
		///      </param></remarks>		<short>    Creates a new tab widget.</short>
		public KTabWidget(QWidget parent, uint flags) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KTabWidget#$", "KTabWidget(QWidget*, Qt::WFlags)", typeof(void), typeof(QWidget), parent, typeof(uint), flags);
		}
		public KTabWidget(QWidget parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KTabWidget#", "KTabWidget(QWidget*)", typeof(void), typeof(QWidget), parent);
		}
		public KTabWidget() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KTabWidget", "KTabWidget()", typeof(void));
		}
		/// <remarks>
		///  Set the tab of the given widget to \a color.
		///  This is simply a convenience method for QTabBar.SetTabTextColor.
		///      </remarks>		<short>    Set the tab of the given widget to \a color.</short>
		public void SetTabTextColor(int index, QColor color) {
			interceptor.Invoke("setTabTextColor$#", "setTabTextColor(int, const QColor&)", typeof(void), typeof(int), index, typeof(QColor), color);
		}
		/// <remarks>
		///  Returns the tab color for the given widget.
		///  This is simply a convenience method for QTabBar.TabTextColor.
		///      </remarks>		<short>    Returns the tab color for the given widget.</short>
		public QColor TabTextColor(int index) {
			return (QColor) interceptor.Invoke("tabTextColor$", "tabTextColor(int) const", typeof(QColor), typeof(int), index);
		}
		/// <remarks>
		///  If \a hide is true, the tabbar is hidden along with any corner
		///  widgets.
		///      </remarks>		<short>    If \a hide is true, the tabbar is hidden along with any corner  widgets.</short>
		public void SetTabBarHidden(bool hide) {
			interceptor.Invoke("setTabBarHidden$", "setTabBarHidden(bool)", typeof(void), typeof(bool), hide);
		}
		/// <remarks>
		///  Returns true if the tabbar is hidden.
		///      </remarks>		<short>    Returns true if the tabbar is hidden.</short>
		public bool IsTabBarHidden() {
			return (bool) interceptor.Invoke("isTabBarHidden", "isTabBarHidden() const", typeof(bool));
		}
		/// <remarks>
		///  Reimplemented for internal reasons.
		///      </remarks>		<short>    Reimplemented for internal reasons.</short>
		public new string TabText(int arg1) {
			return (string) interceptor.Invoke("tabText$", "tabText(int) const", typeof(string), typeof(int), arg1);
		}
		/// <remarks>
		///  Reimplemented for internal reasons.
		///      </remarks>		<short>    Reimplemented for internal reasons.</short>
		public new void SetTabText(int arg1, string arg2) {
			interceptor.Invoke("setTabText$$", "setTabText(int, const QString&)", typeof(void), typeof(int), arg1, typeof(string), arg2);
		}
		/// <remarks>
		///  Move a widget's tab from first to second specified index and emit
		///  signal movedTab( int, int ) afterwards.
		///      </remarks>		<short>    Move a widget's tab from first to second specified index and emit  signal movedTab( int, int ) afterwards.</short>
		[Q_SLOT("void moveTab(int, int)")]
		[SmokeMethod("moveTab(int, int)")]
		public virtual void MoveTab(int arg1, int arg2) {
			interceptor.Invoke("moveTab$$", "moveTab(int, int)", typeof(void), typeof(int), arg1, typeof(int), arg2);
		}
		/// <remarks>
		///  Removes the widget, reimplemented for
		///  internal reasons (keeping labels in sync).
		///      </remarks>		<short>    Removes the widget, reimplemented for  internal reasons (keeping labels in sync).</short>
		[Q_SLOT("void removeTab(int)")]
		[SmokeMethod("removeTab(int)")]
		public virtual void RemoveTab(int index) {
			interceptor.Invoke("removeTab$", "removeTab(int)", typeof(void), typeof(int), index);
		}
		/// <remarks>
		///  If \a enable is true, tab reordering with middle button will be enabled.
		///  Note that once enabled you shouldn't rely on previously queried
		///  currentPageIndex() or indexOf( QWidget  ) values anymore.
		///  You can connect to signal movedTab(int, int) which will notify
		///  you from which index to which index a tab has been moved.
		///      </remarks>		<short>    If \a enable is true, tab reordering with middle button will be enabled.</short>
		[Q_SLOT("void setTabReorderingEnabled(bool)")]
		public void SetTabReorderingEnabled(bool enable) {
			interceptor.Invoke("setTabReorderingEnabled$", "setTabReorderingEnabled(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		///  If \a enable is true, a close button will be shown on mouse hover
		///  over tab icons which will emit signal closeRequest( QWidget  )
		///  when pressed.
		///      </remarks>		<short>    If \a enable is true, a close button will be shown on mouse hover  over tab icons which will emit signal closeRequest( QWidget   )  when pressed.</short>
		[Q_SLOT("void setHoverCloseButton(bool)")]
		public void SetHoverCloseButton(bool enable) {
			interceptor.Invoke("setHoverCloseButton$", "setHoverCloseButton(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		///  If \a delayed is true, a close button will be shown on mouse hover
		///  over tab icons after mouse double click delay else immediately.
		///      </remarks>		<short>    If \a delayed is true, a close button will be shown on mouse hover  over tab icons after mouse double click delay else immediately.</short>
		[Q_SLOT("void setHoverCloseButtonDelayed(bool)")]
		public void SetHoverCloseButtonDelayed(bool delayed) {
			interceptor.Invoke("setHoverCloseButtonDelayed$", "setHoverCloseButtonDelayed(bool)", typeof(void), typeof(bool), delayed);
		}
		/// <remarks>
		///  If \a previous is true, closing the current tab activates the
		///  previous active tab instead of the one to the right.
		///      </remarks>		<short>    If \a previous is true, closing the current tab activates the  previous active tab instead of the one to the right.</short>
		[Q_SLOT("void setTabCloseActivatePrevious(bool)")]
		public void SetTabCloseActivatePrevious(bool previous) {
			interceptor.Invoke("setTabCloseActivatePrevious$", "setTabCloseActivatePrevious(bool)", typeof(void), typeof(bool), previous);
		}
		/// <remarks>
		///  If \a enable is true, tabs will be resized to the width of the tab bar.
		///  Does not work reliably with "QTabWidget foo=new KTabWidget()" and if
		///  you change tabs via the tabbar or by accessing tabs directly.
		///      </remarks>		<short>    If \a enable is true, tabs will be resized to the width of the tab bar.</short>
		[Q_SLOT("void setAutomaticResizeTabs(bool)")]
		public void SetAutomaticResizeTabs(bool enable) {
			interceptor.Invoke("setAutomaticResizeTabs$", "setAutomaticResizeTabs(bool)", typeof(void), typeof(bool), enable);
		}
		[SmokeMethod("mouseDoubleClickEvent(QMouseEvent*)")]
		protected override void MouseDoubleClickEvent(QMouseEvent arg1) {
			interceptor.Invoke("mouseDoubleClickEvent#", "mouseDoubleClickEvent(QMouseEvent*)", typeof(void), typeof(QMouseEvent), arg1);
		}
		[SmokeMethod("mousePressEvent(QMouseEvent*)")]
		protected override void MousePressEvent(QMouseEvent arg1) {
			interceptor.Invoke("mousePressEvent#", "mousePressEvent(QMouseEvent*)", typeof(void), typeof(QMouseEvent), arg1);
		}
		[SmokeMethod("dragEnterEvent(QDragEnterEvent*)")]
		protected override void DragEnterEvent(QDragEnterEvent arg1) {
			interceptor.Invoke("dragEnterEvent#", "dragEnterEvent(QDragEnterEvent*)", typeof(void), typeof(QDragEnterEvent), arg1);
		}
		[SmokeMethod("dragMoveEvent(QDragMoveEvent*)")]
		protected override void DragMoveEvent(QDragMoveEvent arg1) {
			interceptor.Invoke("dragMoveEvent#", "dragMoveEvent(QDragMoveEvent*)", typeof(void), typeof(QDragMoveEvent), arg1);
		}
		[SmokeMethod("dropEvent(QDropEvent*)")]
		protected override void DropEvent(QDropEvent arg1) {
			interceptor.Invoke("dropEvent#", "dropEvent(QDropEvent*)", typeof(void), typeof(QDropEvent), arg1);
		}
		protected int TabBarWidthForMaxChars(int arg1) {
			return (int) interceptor.Invoke("tabBarWidthForMaxChars$", "tabBarWidthForMaxChars(int)", typeof(int), typeof(int), arg1);
		}
		[SmokeMethod("wheelEvent(QWheelEvent*)")]
		protected override void WheelEvent(QWheelEvent arg1) {
			interceptor.Invoke("wheelEvent#", "wheelEvent(QWheelEvent*)", typeof(void), typeof(QWheelEvent), arg1);
		}
		[SmokeMethod("resizeEvent(QResizeEvent*)")]
		protected override void ResizeEvent(QResizeEvent arg1) {
			interceptor.Invoke("resizeEvent#", "resizeEvent(QResizeEvent*)", typeof(void), typeof(QResizeEvent), arg1);
		}
		[SmokeMethod("tabInserted(int)")]
		protected override void TabInserted(int arg1) {
			interceptor.Invoke("tabInserted$", "tabInserted(int)", typeof(void), typeof(int), arg1);
		}
		[SmokeMethod("tabRemoved(int)")]
		protected override void TabRemoved(int arg1) {
			interceptor.Invoke("tabRemoved$", "tabRemoved(int)", typeof(void), typeof(int), arg1);
		}
		[Q_SLOT("void receivedDropEvent(int, QDropEvent*)")]
		[SmokeMethod("receivedDropEvent(int, QDropEvent*)")]
		protected virtual void ReceivedDropEvent(int arg1, QDropEvent arg2) {
			interceptor.Invoke("receivedDropEvent$#", "receivedDropEvent(int, QDropEvent*)", typeof(void), typeof(int), arg1, typeof(QDropEvent), arg2);
		}
		[Q_SLOT("void initiateDrag(int)")]
		[SmokeMethod("initiateDrag(int)")]
		protected virtual void InitiateDrag(int arg1) {
			interceptor.Invoke("initiateDrag$", "initiateDrag(int)", typeof(void), typeof(int), arg1);
		}
		[Q_SLOT("void contextMenu(int, const QPoint&)")]
		[SmokeMethod("contextMenu(int, const QPoint&)")]
		protected virtual void ContextMenu(int arg1, QPoint arg2) {
			interceptor.Invoke("contextMenu$#", "contextMenu(int, const QPoint&)", typeof(void), typeof(int), arg1, typeof(QPoint), arg2);
		}
		[Q_SLOT("void mouseDoubleClick(int)")]
		[SmokeMethod("mouseDoubleClick(int)")]
		protected virtual void MouseDoubleClick(int arg1) {
			interceptor.Invoke("mouseDoubleClick$", "mouseDoubleClick(int)", typeof(void), typeof(int), arg1);
		}
		[Q_SLOT("void mouseMiddleClick(int)")]
		[SmokeMethod("mouseMiddleClick(int)")]
		protected virtual void MouseMiddleClick(int arg1) {
			interceptor.Invoke("mouseMiddleClick$", "mouseMiddleClick(int)", typeof(void), typeof(int), arg1);
		}
		[Q_SLOT("void closeRequest(int)")]
		[SmokeMethod("closeRequest(int)")]
		protected virtual void CloseRequest(int arg1) {
			interceptor.Invoke("closeRequest$", "closeRequest(int)", typeof(void), typeof(int), arg1);
		}
		[Q_SLOT("void wheelDelta(int)")]
		[SmokeMethod("wheelDelta(int)")]
		protected virtual void WheelDelta(int arg1) {
			interceptor.Invoke("wheelDelta$", "wheelDelta(int)", typeof(void), typeof(int), arg1);
		}
		~KTabWidget() {
			interceptor.Invoke("~KTabWidget", "~KTabWidget()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KTabWidget", "~KTabWidget()", typeof(void));
		}
		protected new IKTabWidgetSignals Emit {
			get { return (IKTabWidgetSignals) Q_EMIT; }
		}
	}

	public interface IKTabWidgetSignals : IQTabWidgetSignals {
		/// <remarks>
		///  Connect to this and set accept to true if you can and want to decode the event.
		///      </remarks>		<short>    Connect to this and set accept to true if you can and want to decode the event.</short>
		[Q_SIGNAL("void testCanDecode(const QDragMoveEvent*, bool&)")]
		void TestCanDecode(QDragMoveEvent e, bool accept);
		/// <remarks>
		///  Received an event in the empty space beside tabbar. Usually creates a new tab.
		///  This signal is only possible after testCanDecode and positive accept result.
		///      </remarks>		<short>    Received an event in the empty space beside tabbar.</short>
		[Q_SIGNAL("void receivedDropEvent(QDropEvent*)")]
		void ReceivedDropEvent(QDropEvent arg1);
		/// <remarks>
		///  Received an drop event on given widget's tab.
		///  This signal is only possible after testCanDecode and positive accept result.
		///      </remarks>		<short>    Received an drop event on given widget's tab.</short>
		[Q_SIGNAL("void receivedDropEvent(QWidget*, QDropEvent*)")]
		void ReceivedDropEvent(QWidget arg1, QDropEvent arg2);
		/// <remarks>
		///  Request to start a drag operation on the given tab.
		///      </remarks>		<short>    Request to start a drag operation on the given tab.</short>
		[Q_SIGNAL("void initiateDrag(QWidget*)")]
		void InitiateDrag(QWidget arg1);
		/// <remarks>
		///  The right mouse button was pressed over empty space besides tabbar.
		///      </remarks>		<short>    The right mouse button was pressed over empty space besides tabbar.</short>
		[Q_SIGNAL("void contextMenu(const QPoint&)")]
		void ContextMenu(QPoint arg1);
		/// <remarks>
		///  The right mouse button was pressed over a widget.
		///      </remarks>		<short>    The right mouse button was pressed over a widget.</short>
		[Q_SIGNAL("void contextMenu(QWidget*, const QPoint&)")]
		void ContextMenu(QWidget arg1, QPoint arg2);
		/// <remarks>
		///  A tab was moved from first to second index. This signal is only
		///  possible after you have called setTabReorderingEnabled( true ).
		///      </remarks>		<short>    A tab was moved from first to second index.</short>
		[Q_SIGNAL("void movedTab(int, int)")]
		void MovedTab(int arg1, int arg2);
		/// <remarks>
		///  A double left mouse button click was performed over empty space besides tabbar.
		///      </remarks>		<short>    A double left mouse button click was performed over empty space besides tabbar.</short>
		[Q_SIGNAL("void mouseDoubleClick()")]
		void MouseDoubleClick();
		/// <remarks>
		///  A double left mouse button click was performed over the widget.
		///      </remarks>		<short>    A double left mouse button click was performed over the widget.</short>
		[Q_SIGNAL("void mouseDoubleClick(QWidget*)")]
		void MouseDoubleClick(QWidget arg1);
		/// <remarks>
		///  A middle mouse button click was performed over empty space besides tabbar.
		///      </remarks>		<short>    A middle mouse button click was performed over empty space besides tabbar.</short>
		[Q_SIGNAL("void mouseMiddleClick()")]
		void MouseMiddleClick();
		/// <remarks>
		///  A middle mouse button click was performed over the widget.
		///      </remarks>		<short>    A middle mouse button click was performed over the widget.</short>
		[Q_SIGNAL("void mouseMiddleClick(QWidget*)")]
		void MouseMiddleClick(QWidget arg1);
		/// <remarks>
		///  The close button of a widget's tab was clicked. This signal is
		///  only possible after you have called setHoverCloseButton( true ).
		///      </remarks>		<short>    The close button of a widget's tab was clicked.</short>
		[Q_SIGNAL("void closeRequest(QWidget*)")]
		void CloseRequest(QWidget arg1);
	}
}
