%define name myspell-uk_UA
%define version 1.4.0
%define release 1
%define sourcename spell-uk-%{version}

%define dictdir	%{_datadir}/dict/ooo

Name:		%{name}
Summary:	MySpell spelling dictionary for Ukrainian
Version:	%{version}
Release:	%{release}
URL:		http://ispell-uk.sourceforge.net/
Source:		%{sourcename}.tgz
License:	GPL and LGPL
Group:		System/Internationalization
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildArch:	noarch
#ExcludeArch:	ia64

#Requires:
#BuildRequires:	iconv unzip


%description
myspell-uk_UA package contain spell checking data for Ukrainian language to be used by
OpenOffice.org or any other myspell-capable application, like Mozilla.
#myspell-hyph-uk packages contain hyphenation dictionaries.

%prep
%setup -q -n %{sourcename}

%build
%make myspell

%install
rm -rf $RPM_BUILD_ROOT
make install-myspell-dict PREFIX=$RPM_BUILD_ROOT MYSPELLDIR=%{dictdir}

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [[ ! -f "%{dictdir}/dictionary.lst" ]] || \
      ! grep -q "^DICT[ \t]*uk[ \t]*UA[ \t]*uk_UA\$" %{dictdir}/dictionary.lst
then
    echo "DICT uk UA uk_UA" >> %{dictdir}/dictionary.lst
fi

%preun
if [[ "$1" = "0" ]]; then #This is being completely erased, not upgraded
  perl -ni -e "/^DICT\s*uk\s*UA\s*uk_UA\$/ or print" %{dictdir}/dictionary.lst
fi


%files
%defattr(-,root,root)
%doc src/myspell/README_uk_UA.txt
#COPYING

%{dictdir}/uk_UA.aff
%{dictdir}/uk_UA.dic

%changelog
* Sun May 27 2007 13:00:00 Andriy Rysin <arysin@yahoo.com> 1.4.0
- 10K of new words
- some fixes
- myspell now has triple license: GPL, LGPL and MPL

* Sun Apr 08 2007 06:08:09 Andriy Rysin <arysin@yahoo.com> 1.3.3
- Some updates and mozilla package fixes

* Tue Jan 26 2007 9:23:00 Andriy Rysin <arysin@yahoo.com> 1.3.1
- Some packaging and filenaming fixes

* Tue Jan 26 2007 01:23:00 Andriy Rysin <arysin@yahoo.com> 1.3.0
- Release 1.3.0
- Changed versioning to 3 digits
- Added generation of mozilla xpi package
- Added recognition of grave accent (`) often used as apostrophe
- New words and fixes

* Tue Dec 19 2006 21:18:16 Andriy Rysin <arysin@yahoo.com> 1.2
- Release 1.2
- New words
- Rules and words fixes

* Sat Sep 17 2005 10:37:03 Andriy Rysin <arysin@yahoo.com> 1.1a-1
- Release 1.1a
- Integration of ispell, aspell and myspell into one source package
