/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "widget_options.h"

static int WidgetOptionsDisplayPrivateIndex;

static CompMetadata widgetOptionsMetadata;

static CompPluginVTable *widgetPluginVTable = NULL;
CompPluginVTable widgetOptionsVTable;

#define WIDGET_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, WidgetOptions, o)
#define WIDGET_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, WidgetOptions, o)

typedef struct _WidgetOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[WidgetDisplayOptionNum];
    widgetDisplayOptionChangeNotifyProc notify[WidgetDisplayOptionNum];
} WidgetOptionsDisplay;

typedef struct _WidgetOptionsScreen
{
    CompOption opt[WidgetScreenOptionNum];
    widgetScreenOptionChangeNotifyProc notify[WidgetScreenOptionNum];
} WidgetOptionsScreen;

CompAction * widgetGetToggleKey (CompDisplay *d)
{
    WIDGET_OPTIONS_DISPLAY(d);
    return &od->opt[WidgetDisplayOptionToggleKey].value.action;
}

void widgetSetToggleKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->opt[WidgetDisplayOptionToggleKey].value.action.initiate = init;
}

void widgetSetToggleKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->opt[WidgetDisplayOptionToggleKey].value.action.terminate = term;
}

CompOption * widgetGetToggleKeyOption (CompDisplay *d)
{
    WIDGET_OPTIONS_DISPLAY(d);
    return &od->opt[WidgetDisplayOptionToggleKey];
}

void widgetSetToggleKeyNotify (CompDisplay *d, widgetDisplayOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->notify[WidgetDisplayOptionToggleKey] = notify;
}

CompAction * widgetGetToggleButton (CompDisplay *d)
{
    WIDGET_OPTIONS_DISPLAY(d);
    return &od->opt[WidgetDisplayOptionToggleButton].value.action;
}

void widgetSetToggleButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->opt[WidgetDisplayOptionToggleButton].value.action.initiate = init;
}

void widgetSetToggleButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->opt[WidgetDisplayOptionToggleButton].value.action.terminate = term;
}

CompOption * widgetGetToggleButtonOption (CompDisplay *d)
{
    WIDGET_OPTIONS_DISPLAY(d);
    return &od->opt[WidgetDisplayOptionToggleButton];
}

void widgetSetToggleButtonNotify (CompDisplay *d, widgetDisplayOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->notify[WidgetDisplayOptionToggleButton] = notify;
}

CompAction * widgetGetToggleEdge (CompDisplay *d)
{
    WIDGET_OPTIONS_DISPLAY(d);
    return &od->opt[WidgetDisplayOptionToggleEdge].value.action;
}

void widgetSetToggleEdgeInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->opt[WidgetDisplayOptionToggleEdge].value.action.initiate = init;
}

void widgetSetToggleEdgeTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->opt[WidgetDisplayOptionToggleEdge].value.action.terminate = term;
}

CompOption * widgetGetToggleEdgeOption (CompDisplay *d)
{
    WIDGET_OPTIONS_DISPLAY(d);
    return &od->opt[WidgetDisplayOptionToggleEdge];
}

void widgetSetToggleEdgeNotify (CompDisplay *d, widgetDisplayOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->notify[WidgetDisplayOptionToggleEdge] = notify;
}

CompMatch * widgetGetMatch (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionMatch].value.match;
}

CompOption * widgetGetMatchOption (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionMatch];
}

void widgetSetMatchNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_SCREEN(s);
    os->notify[WidgetScreenOptionMatch] = notify;
}

Bool widgetGetEndOnClick (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return os->opt[WidgetScreenOptionEndOnClick].value.b;
}

CompOption * widgetGetEndOnClickOption (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionEndOnClick];
}

void widgetSetEndOnClickNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_SCREEN(s);
    os->notify[WidgetScreenOptionEndOnClick] = notify;
}

float widgetGetFadeTime (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return os->opt[WidgetScreenOptionFadeTime].value.f;
}

CompOption * widgetGetFadeTimeOption (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionFadeTime];
}

void widgetSetFadeTimeNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_SCREEN(s);
    os->notify[WidgetScreenOptionFadeTime] = notify;
}

int widgetGetBgBrightness (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return os->opt[WidgetScreenOptionBgBrightness].value.i;
}

CompOption * widgetGetBgBrightnessOption (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionBgBrightness];
}

void widgetSetBgBrightnessNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_SCREEN(s);
    os->notify[WidgetScreenOptionBgBrightness] = notify;
}

int widgetGetBgSaturation (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return os->opt[WidgetScreenOptionBgSaturation].value.i;
}

CompOption * widgetGetBgSaturationOption (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionBgSaturation];
}

void widgetSetBgSaturationNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_SCREEN(s);
    os->notify[WidgetScreenOptionBgSaturation] = notify;
}

CompOption * widgetGetDisplayOption (CompDisplay *d, WidgetDisplayOptions num)
{
    WIDGET_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * widgetGetScreenOption (CompScreen *s, WidgetScreenOptions num)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo widgetOptionsDisplayOptionInfo[] = {
    { "toggle_key", "key", 0, 0, 0 },
    { "toggle_button", "button", 0, 0, 0 },
    { "toggle_edge", "edge", 0, 0, 0 },
};

static Bool widgetOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    WIDGET_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, WidgetDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case WidgetDisplayOptionToggleKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WidgetDisplayOptionToggleKey])
                (*od->notify[WidgetDisplayOptionToggleKey]) (d, o, WidgetDisplayOptionToggleKey);
            return TRUE;
        }
        break;
     case WidgetDisplayOptionToggleButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WidgetDisplayOptionToggleButton])
                (*od->notify[WidgetDisplayOptionToggleButton]) (d, o, WidgetDisplayOptionToggleButton);
            return TRUE;
        }
        break;
     case WidgetDisplayOptionToggleEdge:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WidgetDisplayOptionToggleEdge])
                (*od->notify[WidgetDisplayOptionToggleEdge]) (d, o, WidgetDisplayOptionToggleEdge);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * widgetOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    WIDGET_OPTIONS_DISPLAY(d);
    *count = WidgetDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo widgetOptionsScreenOptionInfo[] = {
    { "match", "match", 0, 0, 0 },
    { "end_on_click", "bool", 0, 0, 0 },
    { "fade_time", "float", "<min>0</min><max>10</max>", 0, 0 },
    { "bg_brightness", "int", "<min>0</min><max>100</max>", 0, 0 },
    { "bg_saturation", "int", "<min>0</min><max>100</max>", 0, 0 },
};

static Bool widgetOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    WIDGET_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, WidgetScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case WidgetScreenOptionMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WidgetScreenOptionMatch])
                (*os->notify[WidgetScreenOptionMatch]) (s, o, WidgetScreenOptionMatch);
            return TRUE;
        }
        break;
     case WidgetScreenOptionEndOnClick:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WidgetScreenOptionEndOnClick])
                (*os->notify[WidgetScreenOptionEndOnClick]) (s, o, WidgetScreenOptionEndOnClick);
            return TRUE;
        }
        break;
     case WidgetScreenOptionFadeTime:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WidgetScreenOptionFadeTime])
                (*os->notify[WidgetScreenOptionFadeTime]) (s, o, WidgetScreenOptionFadeTime);
            return TRUE;
        }
        break;
     case WidgetScreenOptionBgBrightness:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WidgetScreenOptionBgBrightness])
                (*os->notify[WidgetScreenOptionBgBrightness]) (s, o, WidgetScreenOptionBgBrightness);
            return TRUE;
        }
        break;
     case WidgetScreenOptionBgSaturation:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WidgetScreenOptionBgSaturation])
                (*os->notify[WidgetScreenOptionBgSaturation]) (s, o, WidgetScreenOptionBgSaturation);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * widgetOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    WIDGET_OPTIONS_SCREEN(s);
    *count = WidgetScreenOptionNum;
    return os->opt;
}

static Bool widgetOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    WidgetOptionsScreen *os;
    
    WIDGET_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(WidgetOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &widgetOptionsMetadata, widgetOptionsScreenOptionInfo, os->opt, WidgetScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void widgetOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, WidgetScreenOptionNum);

    free (os);
}

static Bool widgetOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    WidgetOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(WidgetOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[WidgetOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &widgetOptionsMetadata, widgetOptionsDisplayOptionInfo, od->opt, WidgetDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void widgetOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    WIDGET_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, WidgetDisplayOptionNum);

    free (od);
}

static Bool widgetOptionsInit (CompPlugin *p)
{
    WidgetOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (WidgetOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&widgetOptionsMetadata, "widget",widgetOptionsDisplayOptionInfo, WidgetDisplayOptionNum, widgetOptionsScreenOptionInfo, WidgetScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&widgetOptionsMetadata, "widget");
    if (widgetPluginVTable && widgetPluginVTable->init)
        return widgetPluginVTable->init (p);
    return TRUE;
}

static void widgetOptionsFini (CompPlugin *p)
{
    if (widgetPluginVTable && widgetPluginVTable->fini)
        widgetPluginVTable->fini (p);

    if (WidgetOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (WidgetOptionsDisplayPrivateIndex);

    compFiniMetadata (&widgetOptionsMetadata);
}

static CompBool widgetOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) widgetOptionsInitDisplay,
        (InitPluginObjectProc) widgetOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void widgetOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) widgetOptionsFiniDisplay,
        (FiniPluginObjectProc) widgetOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool widgetOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = widgetOptionsInitObject (p, o);
    if (widgetPluginVTable->initObject)
        rv &= widgetPluginVTable->initObject (p, o);
    return rv;
}

static void widgetOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (widgetPluginVTable->finiObject)
        widgetPluginVTable->finiObject (p, o);
    widgetOptionsFiniObject (p, o);
}

static CompOption * widgetOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) widgetOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) widgetOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool widgetOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) widgetOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) widgetOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
widgetOptionsGetMetadata (CompPlugin *plugin)
{
    return &widgetOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!widgetPluginVTable)
    {
        widgetPluginVTable = getCompPluginInfo ();
        memcpy(&widgetOptionsVTable, widgetPluginVTable, sizeof(CompPluginVTable));
        widgetOptionsVTable.getMetadata = widgetOptionsGetMetadata;
        widgetOptionsVTable.init = widgetOptionsInit;
        widgetOptionsVTable.fini = widgetOptionsFini;
        widgetOptionsVTable.initObject = widgetOptionsInitObjectWrapper;
        widgetOptionsVTable.finiObject = widgetOptionsFiniObjectWrapper;
        widgetOptionsVTable.getObjectOptions = widgetOptionsGetObjectOptions;
	widgetOptionsVTable.setObjectOption = widgetOptionsSetObjectOption;
	
    }
    return &widgetOptionsVTable;
}

